# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.earth_fixed_frame_id import EarthFixedFrameId
from spacetower_orbit_determination_python_client.models.ellipsoid_id import EllipsoidId
from spacetower_orbit_determination_python_client.models.integrator_configuration import IntegratorConfiguration
from spacetower_orbit_determination_python_client.models.perturbation import Perturbation
from spacetower_orbit_determination_python_client.models.shadow_model_type import ShadowModelType
from typing import Optional, Set
from typing_extensions import Self

class SimulationConfiguration(BaseModel):
    """
    SimulationConfiguration
    """ # noqa: E501
    earth_fixed_frame_id: Optional[EarthFixedFrameId] = Field(default=None, description="Earth-fixed frame used in the simulation for force models definition", alias="earthFixedFrameId")
    ellipsoid_id: Optional[EllipsoidId] = Field(default=None, alias="ellipsoidId")
    include_tidal_effects_in_eop_interpolation: Optional[StrictBool] = Field(default=False, description="Flag to include tidal effects when interpolation Earth Orientation Parameters (comes with a higher computational cost, so default is false)", alias="includeTidalEffectsInEopInterpolation")
    shadow_model_type: Optional[ShadowModelType] = Field(default=None, alias="shadowModelType")
    perturbations: Optional[List[Perturbation]] = None
    integrator_configuration: Optional[IntegratorConfiguration] = Field(default=None, alias="integratorConfiguration")
    __properties: ClassVar[List[str]] = ["earthFixedFrameId", "ellipsoidId", "includeTidalEffectsInEopInterpolation", "shadowModelType", "perturbations", "integratorConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SimulationConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in perturbations (list)
        _items = []
        if self.perturbations:
            for _item in self.perturbations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['perturbations'] = _items
        # override the default output from pydantic by calling `to_dict()` of integrator_configuration
        if self.integrator_configuration:
            _dict['integratorConfiguration'] = self.integrator_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SimulationConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "earthFixedFrameId": obj.get("earthFixedFrameId"),
            "ellipsoidId": obj.get("ellipsoidId"),
            "includeTidalEffectsInEopInterpolation": obj.get("includeTidalEffectsInEopInterpolation") if obj.get("includeTidalEffectsInEopInterpolation") is not None else False,
            "shadowModelType": obj.get("shadowModelType"),
            "perturbations": [Perturbation.from_dict(_item) for _item in obj["perturbations"]] if obj.get("perturbations") is not None else None,
            "integratorConfiguration": IntegratorConfiguration.from_dict(obj["integratorConfiguration"]) if obj.get("integratorConfiguration") is not None else None
        })
        return _obj


