# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.propulsion_system import PropulsionSystem
from spacetower_orbit_determination_python_client.models.space_object_type import SpaceObjectType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_determination_python_client.models.box_object import BoxObject
    from spacetower_orbit_determination_python_client.models.isotropic_object import IsotropicObject

class SpaceObject(BaseModel):
    """
    An orbiting body
    """ # noqa: E501
    mass: Optional[Union[StrictFloat, StrictInt]] = Field(default=1000, description="Units [kg]")
    drag_coefficient: Optional[Union[StrictFloat, StrictInt]] = Field(default=2.2, description="Dimensionless drag coefficient. Units [-]", alias="dragCoefficient")
    propulsion_system: Optional[PropulsionSystem] = Field(default=None, alias="propulsionSystem")
    clock_offset: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, description="Clock offset w.r.t. the nominal time. Units [s]", alias="clockOffset")
    space_object_type: SpaceObjectType = Field(alias="spaceObjectType")
    __properties: ClassVar[List[str]] = ["mass", "dragCoefficient", "propulsionSystem", "clockOffset", "spaceObjectType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'spaceObjectType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'BOX': 'BoxObject','ISOTROPIC': 'IsotropicObject'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[BoxObject, IsotropicObject]]:
        """Create an instance of SpaceObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of propulsion_system
        if self.propulsion_system:
            _dict['propulsionSystem'] = self.propulsion_system.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[BoxObject, IsotropicObject]]:
        """Create an instance of SpaceObject from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'BoxObject':
            return import_module("spacetower_orbit_determination_python_client.models.box_object").BoxObject.from_dict(obj)
        if object_type ==  'IsotropicObject':
            return import_module("spacetower_orbit_determination_python_client.models.isotropic_object").IsotropicObject.from_dict(obj)

        raise ValueError("SpaceObject failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


