# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 0.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.estimation_configuration import EstimationConfiguration
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.kalman_drag_coefficient_estimation_request import KalmanDragCoefficientEstimationRequest
from spacetower_orbit_determination_python_client.models.kalman_orbit_estimation_request import KalmanOrbitEstimationRequest
from spacetower_orbit_determination_python_client.models.kalman_reflectivity_coefficient_estimation_request import KalmanReflectivityCoefficientEstimationRequest
from spacetower_orbit_determination_python_client.models.kalman_satellite_clock_offset_estimation_request import KalmanSatelliteClockOffsetEstimationRequest
from spacetower_orbit_determination_python_client.models.kalman_thrust_scale_factors_estimation_request import KalmanThrustScaleFactorsEstimationRequest
from spacetower_orbit_determination_python_client.models.unscented_kalman_filter_configuration import UnscentedKalmanFilterConfiguration
from typing import Optional, Set
from typing_extensions import Self

class UnscentedKalmanFilterEstimationConfiguration(EstimationConfiguration):
    """
    Configuration for Unscented Kalman Filter estimation
    """ # noqa: E501
    unscented_kalman_filter_configuration: Optional[UnscentedKalmanFilterConfiguration] = Field(default=None, alias="unscentedKalmanFilterConfiguration")
    orbit_estimation_request: Optional[KalmanOrbitEstimationRequest] = Field(default=None, alias="orbitEstimationRequest")
    satellite_clock_offset_estimation_request: Optional[KalmanSatelliteClockOffsetEstimationRequest] = Field(default=None, alias="satelliteClockOffsetEstimationRequest")
    drag_coefficient_estimation_request: Optional[KalmanDragCoefficientEstimationRequest] = Field(default=None, alias="dragCoefficientEstimationRequest")
    reflectivity_coefficient_estimation_request: Optional[KalmanReflectivityCoefficientEstimationRequest] = Field(default=None, alias="reflectivityCoefficientEstimationRequest")
    thrust_scale_factors_estimation_request: Optional[KalmanThrustScaleFactorsEstimationRequest] = Field(default=None, alias="thrustScaleFactorsEstimationRequest")
    __properties: ClassVar[List[str]] = ["estimatorType", "unscentedKalmanFilterConfiguration", "orbitEstimationRequest", "satelliteClockOffsetEstimationRequest", "dragCoefficientEstimationRequest", "reflectivityCoefficientEstimationRequest", "thrustScaleFactorsEstimationRequest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UnscentedKalmanFilterEstimationConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of unscented_kalman_filter_configuration
        if self.unscented_kalman_filter_configuration:
            _dict['unscentedKalmanFilterConfiguration'] = self.unscented_kalman_filter_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbit_estimation_request
        if self.orbit_estimation_request:
            _dict['orbitEstimationRequest'] = self.orbit_estimation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of satellite_clock_offset_estimation_request
        if self.satellite_clock_offset_estimation_request:
            _dict['satelliteClockOffsetEstimationRequest'] = self.satellite_clock_offset_estimation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of drag_coefficient_estimation_request
        if self.drag_coefficient_estimation_request:
            _dict['dragCoefficientEstimationRequest'] = self.drag_coefficient_estimation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reflectivity_coefficient_estimation_request
        if self.reflectivity_coefficient_estimation_request:
            _dict['reflectivityCoefficientEstimationRequest'] = self.reflectivity_coefficient_estimation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thrust_scale_factors_estimation_request
        if self.thrust_scale_factors_estimation_request:
            _dict['thrustScaleFactorsEstimationRequest'] = self.thrust_scale_factors_estimation_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UnscentedKalmanFilterEstimationConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "estimatorType": obj.get("estimatorType"),
            "unscentedKalmanFilterConfiguration": UnscentedKalmanFilterConfiguration.from_dict(obj["unscentedKalmanFilterConfiguration"]) if obj.get("unscentedKalmanFilterConfiguration") is not None else None,
            "orbitEstimationRequest": KalmanOrbitEstimationRequest.from_dict(obj["orbitEstimationRequest"]) if obj.get("orbitEstimationRequest") is not None else None,
            "satelliteClockOffsetEstimationRequest": KalmanSatelliteClockOffsetEstimationRequest.from_dict(obj["satelliteClockOffsetEstimationRequest"]) if obj.get("satelliteClockOffsetEstimationRequest") is not None else None,
            "dragCoefficientEstimationRequest": KalmanDragCoefficientEstimationRequest.from_dict(obj["dragCoefficientEstimationRequest"]) if obj.get("dragCoefficientEstimationRequest") is not None else None,
            "reflectivityCoefficientEstimationRequest": KalmanReflectivityCoefficientEstimationRequest.from_dict(obj["reflectivityCoefficientEstimationRequest"]) if obj.get("reflectivityCoefficientEstimationRequest") is not None else None,
            "thrustScaleFactorsEstimationRequest": KalmanThrustScaleFactorsEstimationRequest.from_dict(obj["thrustScaleFactorsEstimationRequest"]) if obj.get("thrustScaleFactorsEstimationRequest") is not None else None
        })
        return _obj


