# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.integrator_configuration import IntegratorConfiguration
from spacetower_orbit_determination_python_client.models.integrator_type import IntegratorType
from spacetower_orbit_determination_python_client.models.variable_step_integrator_type import VariableStepIntegratorType
from typing import Optional, Set
from typing_extensions import Self

class VariableStepIntegratorConfiguration(IntegratorConfiguration):
    """
    Parameters of a variable-step integrator
    """ # noqa: E501
    step_min: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.001, description="Units [s]", alias="stepMin")
    step_max: Optional[Union[StrictFloat, StrictInt]] = Field(default=100, description="Units [s]", alias="stepMax")
    position_error: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.001, description="Position error. Units [m].", alias="positionError")
    variable_step_integrator_type: Optional[VariableStepIntegratorType] = Field(default=None, alias="variableStepIntegratorType")
    __properties: ClassVar[List[str]] = ["integratorType", "stepMin", "stepMax", "positionError", "variableStepIntegratorType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VariableStepIntegratorConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VariableStepIntegratorConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "integratorType": obj.get("integratorType"),
            "stepMin": obj.get("stepMin") if obj.get("stepMin") is not None else 0.001,
            "stepMax": obj.get("stepMax") if obj.get("stepMax") is not None else 100,
            "positionError": obj.get("positionError") if obj.get("positionError") is not None else 0.001,
            "variableStepIntegratorType": obj.get("variableStepIntegratorType")
        })
        return _obj


