# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from spacetower_orbit_determination_python_client.models.cartesian_covariance_allowed_frame_id import CartesianCovarianceAllowedFrameId
from typing import Optional, Set
from typing_extensions import Self

class CartesianProcessNoiseDiagonalMatrix(BaseModel):
    """
    The exact physical interpretation (in particular unit-wise) of these coefficients depends on the process noise being used
    """ # noqa: E501
    frame_id: CartesianCovarianceAllowedFrameId = Field(alias="frameId")
    position_x_coefficient: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="positionXCoefficient")
    position_y_coefficient: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="positionYCoefficient")
    position_z_coefficient: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="positionZCoefficient")
    velocity_x_coefficient: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="velocityXCoefficient")
    velocity_y_coefficient: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="velocityYCoefficient")
    velocity_z_coefficient: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(alias="velocityZCoefficient")
    __properties: ClassVar[List[str]] = ["frameId", "positionXCoefficient", "positionYCoefficient", "positionZCoefficient", "velocityXCoefficient", "velocityYCoefficient", "velocityZCoefficient"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CartesianProcessNoiseDiagonalMatrix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CartesianProcessNoiseDiagonalMatrix from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "frameId": obj.get("frameId"),
            "positionXCoefficient": obj.get("positionXCoefficient"),
            "positionYCoefficient": obj.get("positionYCoefficient"),
            "positionZCoefficient": obj.get("positionZCoefficient"),
            "velocityXCoefficient": obj.get("velocityXCoefficient"),
            "velocityYCoefficient": obj.get("velocityYCoefficient"),
            "velocityZCoefficient": obj.get("velocityZCoefficient")
        })
        return _obj


