# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.orbital_process_noise_provider_type import OrbitalProcessNoiseProviderType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_determination_python_client.models.constant_noise_provider import ConstantNoiseProvider
    from spacetower_orbit_determination_python_client.models.state_noise_compensation_provider import StateNoiseCompensationProvider
    from spacetower_orbit_determination_python_client.models.time_linear_noise_provider import TimeLinearNoiseProvider

class OrbitalProcessNoiseProvider(BaseModel):
    """
    Process noise allows to take into account un-modelled accelerations when performing an orbit determination using Kalman filters. These are often represented as white noise, that is, a signal having constant spectral density and zero mean. Thus, process noise does not affect the estimated value but it does affect the estimated covariance matrix.<br>  The benefit of using process noise is that it prevents an uncontrolled covariance decrease that would make the  filter \"unreactive\" to new measurements. <br> Optimal process noise values for a given application depend on measurement frequency and are often found by by trial and error.<br> Note: process noise for model parameters is constant by default. <br> <br> The following models are available for the orbital state process noise:<br> ```CONSTANT```:  the user specifies a constant diagonal covariance matrix Q that is added during the covariance propagation step.  The dimension of Q is 6. The units should be consistent with the estimated orbit type. <br> This simple model needs to be tuned for each application and works better for small and constant measurement  update intervals. <br> <br> ```TIME_LINEAR```:  the user specifies a constant diagonal matrix Q that can be seen as the increment of state covariance per unit of time because of un-modelled effects. The dimension of Q is 6. The units should be consistent with the estimated orbit type. <br> This amounts to consider un-modelled accelerations as white noise, with the following assumptions:<br> - The matrix Q does not not depend on time<br> - The duration between a measurement and the next is such that the state transition matrix can be approximated with the identity<br> From these, a linear increment ```Q*deltaT``` of the covariance matrix during the measurement interval follows. <br> <br> ```STATE_NOISE_COMPENSATION```:  the user specifies a diagonal matrix Q representing the spectral densities of the un-modelled accelerations. Q has dimension 3. Units are [m^2/s^3]<br> The following assumptions are made:<br> - The transition matrix is that of a purely kinematic motion - If the matrix Q is modelled in a local orbital frame than the transformation to the inertial frame is constant during the elapsed time between subsequent measurements. 
    """ # noqa: E501
    orbital_process_noise_provider_type: Optional[OrbitalProcessNoiseProviderType] = Field(default=None, alias="orbitalProcessNoiseProviderType")
    __properties: ClassVar[List[str]] = ["orbitalProcessNoiseProviderType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'orbitalProcessNoiseProviderType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'CONSTANT': 'ConstantNoiseProvider','STATE_NOISE_COMPENSATION': 'StateNoiseCompensationProvider','TIME_LINEAR': 'TimeLinearNoiseProvider'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[ConstantNoiseProvider, StateNoiseCompensationProvider, TimeLinearNoiseProvider]]:
        """Create an instance of OrbitalProcessNoiseProvider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[ConstantNoiseProvider, StateNoiseCompensationProvider, TimeLinearNoiseProvider]]:
        """Create an instance of OrbitalProcessNoiseProvider from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'ConstantNoiseProvider':
            return import_module("spacetower_orbit_determination_python_client.models.constant_noise_provider").ConstantNoiseProvider.from_dict(obj)
        if object_type ==  'StateNoiseCompensationProvider':
            return import_module("spacetower_orbit_determination_python_client.models.state_noise_compensation_provider").StateNoiseCompensationProvider.from_dict(obj)
        if object_type ==  'TimeLinearNoiseProvider':
            return import_module("spacetower_orbit_determination_python_client.models.time_linear_noise_provider").TimeLinearNoiseProvider.from_dict(obj)

        raise ValueError("OrbitalProcessNoiseProvider failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


