# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.anomaly_type import AnomalyType
from spacetower_orbit_determination_python_client.models.inertial_frame_id import InertialFrameId
from spacetower_orbit_determination_python_client.models.mean_osculating_orbit_type import MeanOsculatingOrbitType
from spacetower_orbit_determination_python_client.models.orbit import Orbit
from spacetower_orbit_determination_python_client.models.orbit_type import OrbitType
from typing import Optional, Set
from typing_extensions import Self

class CircularOrbit(Orbit):
    """
    An orbit described by circular parameters
    """ # noqa: E501
    var_date: str = Field(description="The orbit epoch (UTC)", alias="date")
    semi_major_axis: Union[StrictFloat, StrictInt] = Field(description="The orbit semi-major axis. Units [m]", alias="semiMajorAxis")
    eccentricity_vector_x: Union[StrictFloat, StrictInt] = Field(description="Component x of the eccentricity vector. Units [-]", alias="eccentricityVectorX")
    eccentricity_vector_y: Union[StrictFloat, StrictInt] = Field(description="Component y of the eccentricity vector. Units [-]", alias="eccentricityVectorY")
    inclination: Union[StrictFloat, StrictInt] = Field(description="The orbit inclination. Units [rad]")
    raan: Union[StrictFloat, StrictInt] = Field(description="The orbit right ascension of the ascending node. Units [rad]")
    argument_of_latitude: Union[StrictFloat, StrictInt] = Field(description="The argument of latitude. Units [rad]", alias="argumentOfLatitude")
    anomaly_type: Optional[AnomalyType] = Field(default=None, alias="anomalyType")
    mean_osc_type: MeanOsculatingOrbitType = Field(alias="meanOscType")
    inertial_frame_id: Optional[InertialFrameId] = Field(default=None, alias="inertialFrameId")
    __properties: ClassVar[List[str]] = ["orbitType", "date", "semiMajorAxis", "eccentricityVectorX", "eccentricityVectorY", "inclination", "raan", "argumentOfLatitude", "anomalyType", "meanOscType", "inertialFrameId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CircularOrbit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CircularOrbit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitType": obj.get("orbitType"),
            "date": obj.get("date"),
            "semiMajorAxis": obj.get("semiMajorAxis"),
            "eccentricityVectorX": obj.get("eccentricityVectorX"),
            "eccentricityVectorY": obj.get("eccentricityVectorY"),
            "inclination": obj.get("inclination"),
            "raan": obj.get("raan"),
            "argumentOfLatitude": obj.get("argumentOfLatitude"),
            "anomalyType": obj.get("anomalyType"),
            "meanOscType": obj.get("meanOscType"),
            "inertialFrameId": obj.get("inertialFrameId")
        })
        return _obj


