# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.anomaly_type import AnomalyType
from spacetower_orbit_determination_python_client.models.covariance_orbit_type import CovarianceOrbitType
from spacetower_orbit_determination_python_client.models.inertial_frame_id import InertialFrameId
from spacetower_orbit_determination_python_client.models.orbital_covariance_matrix import OrbitalCovarianceMatrix
from typing import Optional, Set
from typing_extensions import Self

class OrbitalElementsCovarianceMatrix(OrbitalCovarianceMatrix):
    """
    Covariance matrix expressed in terms of orbital elements. The upper triangular part of the <br> matrix is expected. The order of the elements is the same than for ref:'#/components/schemas/InertialFrameId'. Angular values have to be entered in radians.
    """ # noqa: E501
    inertial_frame_id: InertialFrameId = Field(alias="inertialFrameId")
    anomaly_type: Optional[AnomalyType] = Field(default=None, alias="anomalyType")
    matrix_first_row: List[Union[StrictFloat, StrictInt]] = Field(description="Expected number of element is 6", alias="matrixFirstRow")
    matrix_second_row: List[Union[StrictFloat, StrictInt]] = Field(description="Expected number of element is 5", alias="matrixSecondRow")
    matrix_third_row: List[Union[StrictFloat, StrictInt]] = Field(description="Expected number of element is 4", alias="matrixThirdRow")
    matrix_fourth_row: List[Union[StrictFloat, StrictInt]] = Field(description="Expected number of element is 3", alias="matrixFourthRow")
    matrix_fifth_row: List[Union[StrictFloat, StrictInt]] = Field(description="Expected number of element is 2", alias="matrixFifthRow")
    matrix_sixth_row: List[Union[StrictFloat, StrictInt]] = Field(description="Expected number of element is 1", alias="matrixSixthRow")
    __properties: ClassVar[List[str]] = ["covarianceOrbitType", "inertialFrameId", "anomalyType", "matrixFirstRow", "matrixSecondRow", "matrixThirdRow", "matrixFourthRow", "matrixFifthRow", "matrixSixthRow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitalElementsCovarianceMatrix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitalElementsCovarianceMatrix from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "covarianceOrbitType": obj.get("covarianceOrbitType"),
            "inertialFrameId": obj.get("inertialFrameId"),
            "anomalyType": obj.get("anomalyType"),
            "matrixFirstRow": obj.get("matrixFirstRow"),
            "matrixSecondRow": obj.get("matrixSecondRow"),
            "matrixThirdRow": obj.get("matrixThirdRow"),
            "matrixFourthRow": obj.get("matrixFourthRow"),
            "matrixFifthRow": obj.get("matrixFifthRow"),
            "matrixSixthRow": obj.get("matrixSixthRow")
        })
        return _obj


