# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.field_description import FieldDescription
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_determination_python_client.models.batch_residuals import BatchResiduals
    from spacetower_orbit_determination_python_client.models.kalman_residuals import KalmanResiduals
    from spacetower_orbit_determination_python_client.models.kalman_residuals import KalmanResiduals

class DatedEstimatedResiduals(BaseModel):
    """
    Dated list of residual datasets with rejection status and field descriptions
    """ # noqa: E501
    estimator_type: EstimatorType = Field(alias="estimatorType")
    dates: Optional[List[str]] = None
    normalization_flag: Optional[StrictBool] = Field(default=None, alias="normalizationFlag")
    rejection_status: Optional[List[StrictBool]] = Field(default=None, alias="rejectionStatus")
    description: Optional[List[FieldDescription]] = None
    __properties: ClassVar[List[str]] = ["estimatorType", "dates", "normalizationFlag", "rejectionStatus", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'estimatorType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'BATCH_LEAST_SQUARES': 'BatchResiduals','EXTENDED_KALMAN': 'KalmanResiduals','UNSCENTED_KALMAN': 'KalmanResiduals'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[BatchResiduals, KalmanResiduals, KalmanResiduals]]:
        """Create an instance of DatedEstimatedResiduals from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[BatchResiduals, KalmanResiduals, KalmanResiduals]]:
        """Create an instance of DatedEstimatedResiduals from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'BatchResiduals':
            return import_module("spacetower_orbit_determination_python_client.models.batch_residuals").BatchResiduals.from_dict(obj)
        if object_type ==  'KalmanResiduals':
            return import_module("spacetower_orbit_determination_python_client.models.kalman_residuals").KalmanResiduals.from_dict(obj)
        if object_type ==  'KalmanResiduals':
            return import_module("spacetower_orbit_determination_python_client.models.kalman_residuals").KalmanResiduals.from_dict(obj)

        raise ValueError("DatedEstimatedResiduals failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


