# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from spacetower_orbit_determination_python_client.models.earth_centered_frame_id import EarthCenteredFrameId
from spacetower_orbit_determination_python_client.models.measurement_type import MeasurementType
from spacetower_orbit_determination_python_client.models.measurements import Measurements
from typing import Optional, Set
from typing_extensions import Self

class PositionMeasurements(Measurements):
    """
    Dated-weighted position measurement series in a specified frame. Each set of measurement data contains the following ordered content: x-position, y-position, z-position and measurement weight 
    """ # noqa: E501
    earth_centered_frame_id: EarthCenteredFrameId = Field(alias="earthCenteredFrameId")
    standard_deviations: List[Union[Annotated[float, Field(strict=True, gt=0)], Annotated[int, Field(strict=True, gt=0)]]] = Field(description="Standard deviations for the entire set of measurements. The data contains a standard deviation for each of the following ordered content: position (applied to all directions) ", alias="standardDeviations")
    data: List[List[Union[StrictFloat, StrictInt]]] = Field(description="[[pos-x[m], pos-y[m], pos-z[m], weight[-] (default: 1)], ...]")
    __properties: ClassVar[List[str]] = ["measurementType", "dates", "earthCenteredFrameId", "standardDeviations", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PositionMeasurements from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PositionMeasurements from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "measurementType": obj.get("measurementType"),
            "dates": obj.get("dates"),
            "earthCenteredFrameId": obj.get("earthCenteredFrameId"),
            "standardDeviations": obj.get("standardDeviations"),
            "data": obj.get("data")
        })
        return _obj


