# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_determination_python_client.models.radiation_coefficients import RadiationCoefficients
from spacetower_orbit_determination_python_client.models.radiation_coefficients_type import RadiationCoefficientsType
from typing import Optional, Set
from typing_extensions import Self

class ReflectionAbsorptionCoefficients(RadiationCoefficients):
    """
    Radiation properties described by specular reflection and absorption coefficients. The sum of the <br> coefficients must be less or equal to 1. 
    """ # noqa: E501
    specular_reflection_coefficient: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=0.6, description="Dimensionless specular reflection coefficient. It must be in the range [0, 1]. Units [-].", alias="specularReflectionCoefficient")
    absorption_coefficient: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=0.4, description="Dimensionless absorption coefficient. It must be in the range [0, 1]. Units [-].", alias="absorptionCoefficient")
    __properties: ClassVar[List[str]] = ["radiationCoefficientsType", "specularReflectionCoefficient", "absorptionCoefficient"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReflectionAbsorptionCoefficients from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReflectionAbsorptionCoefficients from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "radiationCoefficientsType": obj.get("radiationCoefficientsType"),
            "specularReflectionCoefficient": obj.get("specularReflectionCoefficient") if obj.get("specularReflectionCoefficient") is not None else 0.6,
            "absorptionCoefficient": obj.get("absorptionCoefficient") if obj.get("absorptionCoefficient") is not None else 0.4
        })
        return _obj


