# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.5.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.attitude_law import AttitudeLaw
from spacetower_orbit_determination_python_client.models.attitude_sequence import AttitudeSequence
from spacetower_orbit_determination_python_client.models.attitude_sequence_type import AttitudeSequenceType
from spacetower_orbit_determination_python_client.models.date_triggered_attitude import DateTriggeredAttitude
from typing import Optional, Set
from typing_extensions import Self

class DateTriggeredAttitudeSequence(AttitudeSequence):
    """
    Sequence of attitude laws with date-triggered switches. The initial attitude  law (at simulation start time) must be defined. Following attitude laws, if present,  can be defined at specific attitude switch dates. 
    """ # noqa: E501
    attitude_laws: Optional[List[DateTriggeredAttitude]] = Field(default=None, description="List of attitude laws with switch dates.", alias="attitudeLaws")
    __properties: ClassVar[List[str]] = ["attitudeSequenceType", "initialAttitudeLaw", "attitudeLaws"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DateTriggeredAttitudeSequence from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of initial_attitude_law
        if self.initial_attitude_law:
            _dict['initialAttitudeLaw'] = self.initial_attitude_law.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attitude_laws (list)
        _items = []
        if self.attitude_laws:
            for _item in self.attitude_laws:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attitudeLaws'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DateTriggeredAttitudeSequence from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attitudeSequenceType": obj.get("attitudeSequenceType"),
            "initialAttitudeLaw": AttitudeLaw.from_dict(obj["initialAttitudeLaw"]) if obj.get("initialAttitudeLaw") is not None else None,
            "attitudeLaws": [DateTriggeredAttitude.from_dict(_item) for _item in obj["attitudeLaws"]] if obj.get("attitudeLaws") is not None else None
        })
        return _obj


