# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.5.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.dated_covariance_matrix_set import DatedCovarianceMatrixSet
from spacetower_orbit_determination_python_client.models.estimation_result import EstimationResult
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.kalman_residuals import KalmanResiduals
from spacetower_orbit_determination_python_client.models.orbit import Orbit
from spacetower_orbit_determination_python_client.models.output_model_parameters import OutputModelParameters
from spacetower_orbit_determination_python_client.models.uncertainty_estimate import UncertaintyEstimate
from typing import Optional, Set
from typing_extensions import Self

class KalmanResult(EstimationResult):
    """
    Results from Kalman estimation
    """ # noqa: E501
    output_osculating_orbits: Optional[List[Orbit]] = Field(default=None, description="Array of generic orbits", alias="outputOsculatingOrbits")
    output_mean_orbits: Optional[List[Orbit]] = Field(default=None, description="Array of generic orbits", alias="outputMeanOrbits")
    output_dated_covariance_matrices: Optional[DatedCovarianceMatrixSet] = Field(default=None, alias="outputDatedCovarianceMatrices")
    output_model_parameters: Optional[OutputModelParameters] = Field(default=None, alias="outputModelParameters")
    output_residuals: Optional[KalmanResiduals] = Field(default=None, alias="outputResiduals")
    final_uncertainties: Optional[UncertaintyEstimate] = Field(default=None, alias="finalUncertainties")
    __properties: ClassVar[List[str]] = ["estimatorType", "outputOsculatingOrbits", "outputMeanOrbits", "outputDatedCovarianceMatrices", "outputModelParameters", "outputResiduals", "finalUncertainties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KalmanResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in output_osculating_orbits (list)
        _items = []
        if self.output_osculating_orbits:
            for _item in self.output_osculating_orbits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['outputOsculatingOrbits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in output_mean_orbits (list)
        _items = []
        if self.output_mean_orbits:
            for _item in self.output_mean_orbits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['outputMeanOrbits'] = _items
        # override the default output from pydantic by calling `to_dict()` of output_dated_covariance_matrices
        if self.output_dated_covariance_matrices:
            _dict['outputDatedCovarianceMatrices'] = self.output_dated_covariance_matrices.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output_model_parameters
        if self.output_model_parameters:
            _dict['outputModelParameters'] = self.output_model_parameters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of output_residuals
        if self.output_residuals:
            _dict['outputResiduals'] = self.output_residuals.to_dict()
        # override the default output from pydantic by calling `to_dict()` of final_uncertainties
        if self.final_uncertainties:
            _dict['finalUncertainties'] = self.final_uncertainties.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KalmanResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "estimatorType": obj.get("estimatorType"),
            "outputOsculatingOrbits": [Orbit.from_dict(_item) for _item in obj["outputOsculatingOrbits"]] if obj.get("outputOsculatingOrbits") is not None else None,
            "outputMeanOrbits": [Orbit.from_dict(_item) for _item in obj["outputMeanOrbits"]] if obj.get("outputMeanOrbits") is not None else None,
            "outputDatedCovarianceMatrices": DatedCovarianceMatrixSet.from_dict(obj["outputDatedCovarianceMatrices"]) if obj.get("outputDatedCovarianceMatrices") is not None else None,
            "outputModelParameters": OutputModelParameters.from_dict(obj["outputModelParameters"]) if obj.get("outputModelParameters") is not None else None,
            "outputResiduals": KalmanResiduals.from_dict(obj["outputResiduals"]) if obj.get("outputResiduals") is not None else None,
            "finalUncertainties": UncertaintyEstimate.from_dict(obj["finalUncertainties"]) if obj.get("finalUncertainties") is not None else None
        })
        return _obj


