# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.5.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.isotropic_object_state_estimate import IsotropicObjectStateEstimate
from spacetower_orbit_determination_python_client.models.local_frame_based_maneuver_schedule import LocalFrameBasedManeuverSchedule
from spacetower_orbit_determination_python_client.models.measurements import Measurements
from spacetower_orbit_determination_python_client.models.simulation_configuration import SimulationConfiguration
from typing import Optional, Set
from typing_extensions import Self

class NumericalAprioriResidualsComputationWithoutAttitudeSimulationRequest(BaseModel):
    """
    Request for the computation of residuals between the given measurements and a reference  trajectory obtained propagating the initial guess with special perturbation theory  (numerical propagation). The simulation is run with an isotropic object, meaning that the  attitude is not taken into account. The residuals are computed at each measurement date 
    """ # noqa: E501
    measurements: Measurements
    normalize_residuals: Optional[StrictBool] = Field(default=False, description="Flag to normalize residuals. This normalization is done through dividing the residuals by  the standard deviation of the corresponding measurement ", alias="normalizeResiduals")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="References to the data to be used during the computation")
    simulation_configuration: SimulationConfiguration = Field(alias="simulationConfiguration")
    initial_guess: IsotropicObjectStateEstimate = Field(alias="initialGuess")
    maneuver_schedule: Optional[LocalFrameBasedManeuverSchedule] = Field(default=None, alias="maneuverSchedule")
    __properties: ClassVar[List[str]] = ["measurements", "normalizeResiduals", "data", "simulationConfiguration", "initialGuess", "maneuverSchedule"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalAprioriResidualsComputationWithoutAttitudeSimulationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of simulation_configuration
        if self.simulation_configuration:
            _dict['simulationConfiguration'] = self.simulation_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_guess
        if self.initial_guess:
            _dict['initialGuess'] = self.initial_guess.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maneuver_schedule
        if self.maneuver_schedule:
            _dict['maneuverSchedule'] = self.maneuver_schedule.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalAprioriResidualsComputationWithoutAttitudeSimulationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "measurements": Measurements.from_dict(obj["measurements"]) if obj.get("measurements") is not None else None,
            "normalizeResiduals": obj.get("normalizeResiduals") if obj.get("normalizeResiduals") is not None else False,
            "data": obj.get("data"),
            "simulationConfiguration": SimulationConfiguration.from_dict(obj["simulationConfiguration"]) if obj.get("simulationConfiguration") is not None else None,
            "initialGuess": IsotropicObjectStateEstimate.from_dict(obj["initialGuess"]) if obj.get("initialGuess") is not None else None,
            "maneuverSchedule": LocalFrameBasedManeuverSchedule.from_dict(obj["maneuverSchedule"]) if obj.get("maneuverSchedule") is not None else None
        })
        return _obj


