# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_determination_python_client.models.measurements import Measurements
from spacetower_orbit_determination_python_client.models.two_line_element_orbit import TwoLineElementOrbit
from typing import Optional, Set
from typing_extensions import Self

class TleAprioriResidualsComputationRequest(BaseModel):
    """
    Request for the computation of residuals between the given measurements and a reference  trajectory obtained propagating the initial TLE with simplified general perturbation models. The residuals are computed at each measurement date 
    """ # noqa: E501
    measurements: Measurements
    normalize_residuals: Optional[StrictBool] = Field(default=False, description="Flag to normalize residuals. This normalization is done through dividing the residuals by  the standard deviation of the corresponding measurement ", alias="normalizeResiduals")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="References to the data to be used during the computation")
    tle_orbit: TwoLineElementOrbit = Field(alias="tleOrbit")
    clock_offset: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Spacecraft's clock offset (used by some measurements, for example the ones from onboard  GPS data) ", alias="clockOffset")
    __properties: ClassVar[List[str]] = ["measurements", "normalizeResiduals", "data", "tleOrbit", "clockOffset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TleAprioriResidualsComputationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tle_orbit
        if self.tle_orbit:
            _dict['tleOrbit'] = self.tle_orbit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TleAprioriResidualsComputationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "measurements": Measurements.from_dict(obj["measurements"]) if obj.get("measurements") is not None else None,
            "normalizeResiduals": obj.get("normalizeResiduals") if obj.get("normalizeResiduals") is not None else False,
            "data": obj.get("data"),
            "tleOrbit": TwoLineElementOrbit.from_dict(obj["tleOrbit"]) if obj.get("tleOrbit") is not None else None,
            "clockOffset": obj.get("clockOffset") if obj.get("clockOffset") is not None else 0.0
        })
        return _obj


