# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from spacetower_orbit_determination_python_client.models.attitude_law import AttitudeLaw
from spacetower_orbit_determination_python_client.models.attitude_law_type import AttitudeLawType
from spacetower_orbit_determination_python_client.models.rotating_local_frame_id import RotatingLocalFrameId
from spacetower_orbit_determination_python_client.models.rotation_convention import RotationConvention
from spacetower_orbit_determination_python_client.models.rotation_order import RotationOrder
from typing import Optional, Set
from typing_extensions import Self

class InterpolatedLocalFrameAttitudeLaw(AttitudeLaw):
    """
    Interpolation between a list of dated local frame attitudes. It uses piecewise cubic Lagrange interpolation 
    """ # noqa: E501
    local_frame_id: RotatingLocalFrameId = Field(alias="localFrameId")
    rotation_order: Optional[RotationOrder] = Field(default=None, alias="rotationOrder")
    rotation_convention: Optional[RotationConvention] = Field(default=None, alias="rotationConvention")
    dates: Annotated[List[str], Field(min_length=4)] = Field(description="The UTC dates of the data points")
    rotation_angles: Annotated[List[List[Union[StrictFloat, StrictInt]]], Field(min_length=4)] = Field(description="Each entry (DataEntry) corresponds to a date, and contains the list of the rotation angles around the axes of the local orbital frame in the chosen order: <br> [[firstAngle[rad], secondAngle[rad], thirdAngle[rad]], ...]", alias="rotationAngles")
    __properties: ClassVar[List[str]] = ["attitudeLawType", "localFrameId", "rotationOrder", "rotationConvention", "dates", "rotationAngles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InterpolatedLocalFrameAttitudeLaw from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InterpolatedLocalFrameAttitudeLaw from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attitudeLawType": obj.get("attitudeLawType"),
            "localFrameId": obj.get("localFrameId"),
            "rotationOrder": obj.get("rotationOrder"),
            "rotationConvention": obj.get("rotationConvention"),
            "dates": obj.get("dates"),
            "rotationAngles": obj.get("rotationAngles")
        })
        return _obj


