# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.estimated_orbit_type import EstimatedOrbitType
from spacetower_orbit_determination_python_client.models.orbital_covariance_matrix import OrbitalCovarianceMatrix
from spacetower_orbit_determination_python_client.models.orbital_process_noise_provider import OrbitalProcessNoiseProvider
from typing import Optional, Set
from typing_extensions import Self

class KalmanOrbitEstimationRequest(BaseModel):
    """
    Request for computing orbit determination with Kalman Filter
    """ # noqa: E501
    estimated_orbit_type: EstimatedOrbitType = Field(alias="estimatedOrbitType")
    orbital_covariance_matrix: OrbitalCovarianceMatrix = Field(alias="orbitalCovarianceMatrix")
    orbital_process_noise_provider: Optional[OrbitalProcessNoiseProvider] = Field(default=None, alias="orbitalProcessNoiseProvider")
    __properties: ClassVar[List[str]] = ["estimatedOrbitType", "orbitalCovarianceMatrix", "orbitalProcessNoiseProvider"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KalmanOrbitEstimationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of orbital_covariance_matrix
        if self.orbital_covariance_matrix:
            _dict['orbitalCovarianceMatrix'] = self.orbital_covariance_matrix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbital_process_noise_provider
        if self.orbital_process_noise_provider:
            _dict['orbitalProcessNoiseProvider'] = self.orbital_process_noise_provider.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KalmanOrbitEstimationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "estimatedOrbitType": obj.get("estimatedOrbitType"),
            "orbitalCovarianceMatrix": OrbitalCovarianceMatrix.from_dict(obj["orbitalCovarianceMatrix"]) if obj.get("orbitalCovarianceMatrix") is not None else None,
            "orbitalProcessNoiseProvider": OrbitalProcessNoiseProvider.from_dict(obj["orbitalProcessNoiseProvider"]) if obj.get("orbitalProcessNoiseProvider") is not None else None
        })
        return _obj


