# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class AttitudeLawType(str, Enum):
    """
    - ```EARTH_ORIENTED_MANEUVER```** Aligns the thruster axis to a given maneuver direction,    expressed in a local orbital frame. A rotation around the thruster axis is computed in order    to have a user-defined axis oriented towards the Earth as much as possible.    __Note: applies to BoxObject with a propulsion system only.__ - ```LOCAL_FRAME_ATTITUDE``` Attitude law defined by rotation angles around the axes of a local orbital frame. By default the space object axes are aligned with those of the orbital frame. - ```INTERPOLATED_LOCAL_FRAME_ATTITUDE``` Lagrange interpolation between a list of dated local frame attitudes, using only rotations and ignoring rotation rates. - ```NADIR_POINTING``` Attitude law with a space object-fixed frame axis pointing towards nadir.   Other directions are arbitrary. - ```SUN_ENHANCED_MANEUVER``` Aligns the thruster axis to a given maneuver direction, expressed    in a local orbital frame. A rotation around the thruster axis is computed in order to optimize   the lighting of the solar array.   __Note: applies to BoxObject with a propulsion system only.__ - ```SUN_POINTING``` Attitude pointing the solar array normal towards the Sun, with the last    degree of freedom of the rotation set arbitrarily.   __Note: applies to BoxObject with solar array geometry only.__ 
    """

    """
    allowed enum values
    """
    EARTH_ORIENTED_MANEUVER = 'EARTH_ORIENTED_MANEUVER'
    LOCAL_FRAME_ATTITUDE = 'LOCAL_FRAME_ATTITUDE'
    INTERPOLATED_LOCAL_FRAME_ATTITUDE = 'INTERPOLATED_LOCAL_FRAME_ATTITUDE'
    NADIR_POINTING = 'NADIR_POINTING'
    SUN_ENHANCED_MANEUVER = 'SUN_ENHANCED_MANEUVER'
    SUN_POINTING = 'SUN_POINTING'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of AttitudeLawType from a JSON string"""
        return cls(json.loads(json_str))


