# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.batch_least_squares_measurement_parameters_estimation_request import BatchLeastSquaresMeasurementParametersEstimationRequest
from spacetower_orbit_determination_python_client.models.batch_least_squares_orbit_estimation_request import BatchLeastSquaresOrbitEstimationRequest
from spacetower_orbit_determination_python_client.models.batch_least_squares_propagation_parameters_estimation_request import BatchLeastSquaresPropagationParametersEstimationRequest
from spacetower_orbit_determination_python_client.models.estimation_configuration import EstimationConfiguration
from spacetower_orbit_determination_python_client.models.estimator_type import EstimatorType
from spacetower_orbit_determination_python_client.models.least_squares_configuration import LeastSquaresConfiguration
from spacetower_orbit_determination_python_client.models.static_outlier_filter import StaticOutlierFilter
from typing import Optional, Set
from typing_extensions import Self

class BatchLeastSquaresEstimationConfiguration(EstimationConfiguration):
    """
    Configuration for batch least squares estimation
    """ # noqa: E501
    outlier_filter: Optional[StaticOutlierFilter] = Field(default=None, alias="outlierFilter")
    least_squares_configuration: Optional[LeastSquaresConfiguration] = Field(default=None, alias="leastSquaresConfiguration")
    orbit_estimation_request: Optional[BatchLeastSquaresOrbitEstimationRequest] = Field(default=None, alias="orbitEstimationRequest")
    propagation_parameters_estimation_request: Optional[BatchLeastSquaresPropagationParametersEstimationRequest] = Field(default=None, alias="propagationParametersEstimationRequest")
    measurement_parameters_estimation_request: Optional[BatchLeastSquaresMeasurementParametersEstimationRequest] = Field(default=None, alias="measurementParametersEstimationRequest")
    __properties: ClassVar[List[str]] = ["estimatorType", "outlierFilter", "leastSquaresConfiguration", "orbitEstimationRequest", "propagationParametersEstimationRequest", "measurementParametersEstimationRequest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BatchLeastSquaresEstimationConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of outlier_filter
        if self.outlier_filter:
            _dict['outlierFilter'] = self.outlier_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of least_squares_configuration
        if self.least_squares_configuration:
            _dict['leastSquaresConfiguration'] = self.least_squares_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbit_estimation_request
        if self.orbit_estimation_request:
            _dict['orbitEstimationRequest'] = self.orbit_estimation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of propagation_parameters_estimation_request
        if self.propagation_parameters_estimation_request:
            _dict['propagationParametersEstimationRequest'] = self.propagation_parameters_estimation_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurement_parameters_estimation_request
        if self.measurement_parameters_estimation_request:
            _dict['measurementParametersEstimationRequest'] = self.measurement_parameters_estimation_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BatchLeastSquaresEstimationConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "estimatorType": obj.get("estimatorType"),
            "outlierFilter": StaticOutlierFilter.from_dict(obj["outlierFilter"]) if obj.get("outlierFilter") is not None else None,
            "leastSquaresConfiguration": LeastSquaresConfiguration.from_dict(obj["leastSquaresConfiguration"]) if obj.get("leastSquaresConfiguration") is not None else None,
            "orbitEstimationRequest": BatchLeastSquaresOrbitEstimationRequest.from_dict(obj["orbitEstimationRequest"]) if obj.get("orbitEstimationRequest") is not None else None,
            "propagationParametersEstimationRequest": BatchLeastSquaresPropagationParametersEstimationRequest.from_dict(obj["propagationParametersEstimationRequest"]) if obj.get("propagationParametersEstimationRequest") is not None else None,
            "measurementParametersEstimationRequest": BatchLeastSquaresMeasurementParametersEstimationRequest.from_dict(obj["measurementParametersEstimationRequest"]) if obj.get("measurementParametersEstimationRequest") is not None else None
        })
        return _obj


