# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.earth_centered_frame_id import EarthCenteredFrameId
from spacetower_orbit_determination_python_client.models.orbit import Orbit
from spacetower_orbit_determination_python_client.models.orbit_type import OrbitType
from spacetower_orbit_determination_python_client.models.vector3_d import Vector3D
from typing import Optional, Set
from typing_extensions import Self

class CartesianOrbit(Orbit):
    """
    An orbit described by Cartesian parameters
    """ # noqa: E501
    var_date: str = Field(description="The orbit epoch (UTC)", alias="date")
    position: Vector3D
    velocity: Vector3D
    earth_centered_frame_id: Optional[EarthCenteredFrameId] = Field(default=None, alias="earthCenteredFrameId")
    __properties: ClassVar[List[str]] = ["orbitType", "date", "position", "velocity", "earthCenteredFrameId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CartesianOrbit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of velocity
        if self.velocity:
            _dict['velocity'] = self.velocity.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CartesianOrbit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitType": obj.get("orbitType"),
            "date": obj.get("date"),
            "position": Vector3D.from_dict(obj["position"]) if obj.get("position") is not None else None,
            "velocity": Vector3D.from_dict(obj["velocity"]) if obj.get("velocity") is not None else None,
            "earthCenteredFrameId": obj.get("earthCenteredFrameId")
        })
        return _obj


