# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from spacetower_orbit_determination_python_client.models.atmosphere_model import AtmosphereModel
from spacetower_orbit_determination_python_client.models.atmosphere_type import AtmosphereType
from typing import Optional, Set
from typing_extensions import Self

class HarrisPriesterAtmosphere(AtmosphereModel):
    """
    Static atmosphere model
    """ # noqa: E501
    solar_flux: Optional[Annotated[int, Field(le=275, strict=True, ge=65)]] = Field(default=None, description="F10.7 coefficient, considered constant. If not given, will be retrieved at initial date from CSSI data. Units [sfu]", alias="solarFlux")
    __properties: ClassVar[List[str]] = ["atmosphereType", "solarFlux"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HarrisPriesterAtmosphere from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HarrisPriesterAtmosphere from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "atmosphereType": obj.get("atmosphereType"),
            "solarFlux": obj.get("solarFlux")
        })
        return _obj


