# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.dated_local_frame_finite_thrust_direction import DatedLocalFrameFiniteThrustDirection
from typing import Optional, Set
from typing_extensions import Self

class LocalFrameBasedFiniteThrustSequence(BaseModel):
    """
    Sequence of finite thrust burns. Requires a propulsion system in the Space Object
    """ # noqa: E501
    dated_local_frame_finite_thrusts: Optional[List[DatedLocalFrameFiniteThrustDirection]] = Field(default=None, alias="datedLocalFrameFiniteThrusts")
    __properties: ClassVar[List[str]] = ["datedLocalFrameFiniteThrusts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LocalFrameBasedFiniteThrustSequence from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dated_local_frame_finite_thrusts (list)
        _items = []
        if self.dated_local_frame_finite_thrusts:
            for _item in self.dated_local_frame_finite_thrusts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['datedLocalFrameFiniteThrusts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LocalFrameBasedFiniteThrustSequence from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datedLocalFrameFiniteThrusts": [DatedLocalFrameFiniteThrustDirection.from_dict(_item) for _item in obj["datedLocalFrameFiniteThrusts"]] if obj.get("datedLocalFrameFiniteThrusts") is not None else None
        })
        return _obj


