# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_determination_python_client.models.orbit_type import OrbitType
from spacetower_orbit_determination_python_client.models.osculating_to_mean_conversion_theory import OsculatingToMeanConversionTheory
from spacetower_orbit_determination_python_client.models.output_covariance_configuration import OutputCovarianceConfiguration
from spacetower_orbit_determination_python_client.models.residual_computation_configuration import ResidualComputationConfiguration
from typing import Optional, Set
from typing_extensions import Self

class PostProcessConfiguration(BaseModel):
    """
    Configuration for post processing of estimation results. If output mean orbits are requested, its orbit type is  defined by the ```meanTheory```, where the anomaly type is always ```MEAN```, and its frame is:<br> - ```TEME``` inertial frame for the ```SGP4``` theory  - ```GCRF``` inertial frame for the ```DSST_6X0``` theory 
    """ # noqa: E501
    output_osculating_orbit_type: Optional[OrbitType] = Field(default=None, alias="outputOsculatingOrbitType")
    mean_theory: Optional[OsculatingToMeanConversionTheory] = Field(default=None, alias="meanTheory")
    residual_computation_configuration: Optional[ResidualComputationConfiguration] = Field(default=None, alias="residualComputationConfiguration")
    final_covariance_configuration: Optional[OutputCovarianceConfiguration] = Field(default=None, alias="finalCovarianceConfiguration")
    __properties: ClassVar[List[str]] = ["outputOsculatingOrbitType", "meanTheory", "residualComputationConfiguration", "finalCovarianceConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostProcessConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of residual_computation_configuration
        if self.residual_computation_configuration:
            _dict['residualComputationConfiguration'] = self.residual_computation_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of final_covariance_configuration
        if self.final_covariance_configuration:
            _dict['finalCovarianceConfiguration'] = self.final_covariance_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostProcessConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "outputOsculatingOrbitType": obj.get("outputOsculatingOrbitType"),
            "meanTheory": obj.get("meanTheory"),
            "residualComputationConfiguration": ResidualComputationConfiguration.from_dict(obj["residualComputationConfiguration"]) if obj.get("residualComputationConfiguration") is not None else None,
            "finalCovarianceConfiguration": OutputCovarianceConfiguration.from_dict(obj["finalCovarianceConfiguration"]) if obj.get("finalCovarianceConfiguration") is not None else None
        })
        return _obj


