# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from spacetower_orbit_determination_python_client.models.orbital_process_noise_provider import OrbitalProcessNoiseProvider
from spacetower_orbit_determination_python_client.models.orbital_process_noise_provider_type import OrbitalProcessNoiseProviderType
from spacetower_orbit_determination_python_client.models.spectral_density_matrix import SpectralDensityMatrix
from typing import Optional, Set
from typing_extensions import Self

class StateNoiseCompensationProvider(OrbitalProcessNoiseProvider):
    """
    The user specifies a diagonal matrix Q representing the spectral densities of the un-modelled accelerations. Q has dimension 3. Units are [m^2/s^3]<br> The following assumptions are made:<br> - The transition matrix is that of a purely kinematic motion - If the matrix Q is modelled in a local orbital frame than the transformation to the inertial frame is constant during the elapsed time between subsequent measurements. 
    """ # noqa: E501
    spectral_density_matrix: SpectralDensityMatrix = Field(alias="spectralDensityMatrix")
    __properties: ClassVar[List[str]] = ["orbitalProcessNoiseProviderType", "spectralDensityMatrix"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StateNoiseCompensationProvider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of spectral_density_matrix
        if self.spectral_density_matrix:
            _dict['spectralDensityMatrix'] = self.spectral_density_matrix.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StateNoiseCompensationProvider from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitalProcessNoiseProviderType": obj.get("orbitalProcessNoiseProviderType"),
            "spectralDensityMatrix": SpectralDensityMatrix.from_dict(obj["spectralDensityMatrix"]) if obj.get("spectralDensityMatrix") is not None else None
        })
        return _obj


