# coding: utf-8

"""
    Orbit Determination API

    Orbit Determination API

    The version of the OpenAPI document: 1.6.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UnscentedTransformConfiguration(BaseModel):
    """
    The unscented transform uses three parameters: alpha, beta and kappa. <br> Alpha determines the spread of the sigma points around the process state, kappa is a secondary scaling parameter, and beta is used to incorporate prior knowledge of the distribution of the process state. 
    """ # noqa: E501
    alpha: Optional[Union[Annotated[float, Field(le=10, strict=True, ge=0)], Annotated[int, Field(le=10, strict=True, ge=0)]]] = 0.5
    beta: Optional[Union[Annotated[float, Field(le=10, strict=True, ge=0)], Annotated[int, Field(le=10, strict=True, ge=0)]]] = 2
    kappa: Optional[Union[Annotated[float, Field(le=10, strict=True, ge=0)], Annotated[int, Field(le=10, strict=True, ge=0)]]] = 0
    __properties: ClassVar[List[str]] = ["alpha", "beta", "kappa"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UnscentedTransformConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UnscentedTransformConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alpha": obj.get("alpha") if obj.get("alpha") is not None else 0.5,
            "beta": obj.get("beta") if obj.get("beta") is not None else 2,
            "kappa": obj.get("kappa") if obj.get("kappa") is not None else 0
        })
        return _obj


