# spacetower_orbit_extrapolation_python_client
Measurements Generation API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.1.0
- Generator version: 7.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import spacetower_orbit_extrapolation_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import spacetower_orbit_extrapolation_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import spacetower_orbit_extrapolation_python_client
from spacetower_orbit_extrapolation_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://measurements-generation.exoops.57.128.40.142.sslip.io
# See configuration.py for a list of all supported configuration parameters.
configuration = spacetower_orbit_extrapolation_python_client.Configuration(
    host = "http://measurements-generation.exoops.57.128.40.142.sslip.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = spacetower_orbit_extrapolation_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with spacetower_orbit_extrapolation_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = spacetower_orbit_extrapolation_python_client.DefaultApi(api_client)
    measurements_generation_request = spacetower_orbit_extrapolation_python_client.MeasurementsGenerationRequest() # MeasurementsGenerationRequest |  (optional)

    try:
        # Measurements generation
        api_response = api_instance.generate_measurements(measurements_generation_request=measurements_generation_request)
        print("The response of DefaultApi->generate_measurements:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->generate_measurements: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://measurements-generation.exoops.57.128.40.142.sslip.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**generate_measurements**](docs/DefaultApi.md#generate_measurements) | **POST** /measurements/generate | Measurements generation


## Documentation For Models

 - [AnomalyType](docs/AnomalyType.md)
 - [AzElMeasurementsRequest](docs/AzElMeasurementsRequest.md)
 - [AzimuthElevationMeasurements](docs/AzimuthElevationMeasurements.md)
 - [EarthCenteredFrameId](docs/EarthCenteredFrameId.md)
 - [EarthEllipsoidConfiguration](docs/EarthEllipsoidConfiguration.md)
 - [EarthFixedFrameId](docs/EarthFixedFrameId.md)
 - [EllipsoidId](docs/EllipsoidId.md)
 - [FieldDescription](docs/FieldDescription.md)
 - [GpsNmeaMeasurements](docs/GpsNmeaMeasurements.md)
 - [GpsNmeaMeasurementsRequest](docs/GpsNmeaMeasurementsRequest.md)
 - [GroundStation](docs/GroundStation.md)
 - [InertialFrameId](docs/InertialFrameId.md)
 - [MeasurementRequest](docs/MeasurementRequest.md)
 - [MeasurementType](docs/MeasurementType.md)
 - [MeasurementsGenerationRequest](docs/MeasurementsGenerationRequest.md)
 - [MeasurementsGenerationResult](docs/MeasurementsGenerationResult.md)
 - [NoiseFrameId](docs/NoiseFrameId.md)
 - [OrbitEphemeris](docs/OrbitEphemeris.md)
 - [OrbitalParameterType](docs/OrbitalParameterType.md)
 - [PositionCorrelationCoefficients](docs/PositionCorrelationCoefficients.md)
 - [PositionMeasurements](docs/PositionMeasurements.md)
 - [PositionMeasurementsRequest](docs/PositionMeasurementsRequest.md)
 - [PositionStandardDeviation](docs/PositionStandardDeviation.md)
 - [PositionVelocityCorrelationCoefficients](docs/PositionVelocityCorrelationCoefficients.md)
 - [PositionVelocityEphemeris](docs/PositionVelocityEphemeris.md)
 - [PositionVelocityMeasurements](docs/PositionVelocityMeasurements.md)
 - [PositionVelocityMeasurementsRequest](docs/PositionVelocityMeasurementsRequest.md)
 - [RaDecMeasurements](docs/RaDecMeasurements.md)
 - [RaDecMeasurementsRequest](docs/RaDecMeasurementsRequest.md)
 - [StationMask](docs/StationMask.md)
 - [TimestampedOutputData](docs/TimestampedOutputData.md)
 - [VelocityCorrelationCoefficients](docs/VelocityCorrelationCoefficients.md)
 - [VelocityStandardDeviation](docs/VelocityStandardDeviation.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




