# coding: utf-8

"""
    Measurements Generation API

    Measurements Generation API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.earth_fixed_frame_id import EarthFixedFrameId
from spacetower_orbit_extrapolation_python_client.models.ellipsoid_id import EllipsoidId
from typing import Optional, Set
from typing_extensions import Self

class EarthEllipsoidConfiguration(BaseModel):
    """
    Earth ellipsoid configuration with an Earth fixed frame
    """ # noqa: E501
    earth_centered_fixed_frame_id: Optional[EarthFixedFrameId] = Field(default=None, alias="earthCenteredFixedFrameId")
    ellipsoid_model: Optional[EllipsoidId] = Field(default=None, alias="ellipsoidModel")
    include_tidal_effects_in_eop_interpolation: Optional[StrictBool] = Field(default=False, description="Flag to include tidal effects when interpolation Earth Orientation Parameters (comes with a higher computational cost, so default is false)", alias="includeTidalEffectsInEopInterpolation")
    __properties: ClassVar[List[str]] = ["earthCenteredFixedFrameId", "ellipsoidModel", "includeTidalEffectsInEopInterpolation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EarthEllipsoidConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EarthEllipsoidConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "earthCenteredFixedFrameId": obj.get("earthCenteredFixedFrameId"),
            "ellipsoidModel": obj.get("ellipsoidModel"),
            "includeTidalEffectsInEopInterpolation": obj.get("includeTidalEffectsInEopInterpolation") if obj.get("includeTidalEffectsInEopInterpolation") is not None else False
        })
        return _obj


