# coding: utf-8

"""
    Measurements Generation API

    Measurements Generation API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from spacetower_orbit_extrapolation_python_client.models.measurement_type import MeasurementType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_extrapolation_python_client.models.ra_dec_measurements_request import RaDecMeasurementsRequest
    from spacetower_orbit_extrapolation_python_client.models.az_el_measurements_request import AzElMeasurementsRequest
    from spacetower_orbit_extrapolation_python_client.models.gps_nmea_measurements_request import GpsNmeaMeasurementsRequest
    from spacetower_orbit_extrapolation_python_client.models.position_measurements_request import PositionMeasurementsRequest
    from spacetower_orbit_extrapolation_python_client.models.position_velocity_measurements_request import PositionVelocityMeasurementsRequest

class MeasurementRequest(BaseModel):
    """
    Common type for generated measurements
    """ # noqa: E501
    measurement_type: MeasurementType = Field(alias="measurementType")
    __properties: ClassVar[List[str]] = ["measurementType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'measurementType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'ASTROMETRIC_RA_DEC': 'RaDecMeasurementsRequest','AZIMUTH_ELEVATION': 'AzElMeasurementsRequest','GPS_NMEA': 'GpsNmeaMeasurementsRequest','POSITION': 'PositionMeasurementsRequest','POSITION_VELOCITY': 'PositionVelocityMeasurementsRequest'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[RaDecMeasurementsRequest, AzElMeasurementsRequest, GpsNmeaMeasurementsRequest, PositionMeasurementsRequest, PositionVelocityMeasurementsRequest]]:
        """Create an instance of MeasurementRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[RaDecMeasurementsRequest, AzElMeasurementsRequest, GpsNmeaMeasurementsRequest, PositionMeasurementsRequest, PositionVelocityMeasurementsRequest]]:
        """Create an instance of MeasurementRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'RaDecMeasurementsRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.ra_dec_measurements_request").RaDecMeasurementsRequest.from_dict(obj)
        if object_type ==  'AzElMeasurementsRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.az_el_measurements_request").AzElMeasurementsRequest.from_dict(obj)
        if object_type ==  'GpsNmeaMeasurementsRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.gps_nmea_measurements_request").GpsNmeaMeasurementsRequest.from_dict(obj)
        if object_type ==  'PositionMeasurementsRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.position_measurements_request").PositionMeasurementsRequest.from_dict(obj)
        if object_type ==  'PositionVelocityMeasurementsRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.position_velocity_measurements_request").PositionVelocityMeasurementsRequest.from_dict(obj)

        raise ValueError("MeasurementRequest failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


