# coding: utf-8

"""
    Measurements Generation API

    Measurements Generation API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.measurement_request import MeasurementRequest
from spacetower_orbit_extrapolation_python_client.models.orbit_ephemeris import OrbitEphemeris
from typing import Optional, Set
from typing_extensions import Self

class MeasurementsGenerationRequest(BaseModel):
    """
    Configuration for measurements generation
    """ # noqa: E501
    orbit_ephemeris_data: Optional[OrbitEphemeris] = Field(default=None, alias="orbitEphemerisData")
    measurements_requests: List[MeasurementRequest] = Field(alias="measurementsRequests")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="References to the data to be used during the computation")
    __properties: ClassVar[List[str]] = ["orbitEphemerisData", "measurementsRequests", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeasurementsGenerationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of orbit_ephemeris_data
        if self.orbit_ephemeris_data:
            _dict['orbitEphemerisData'] = self.orbit_ephemeris_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in measurements_requests (list)
        _items = []
        if self.measurements_requests:
            for _item in self.measurements_requests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['measurementsRequests'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeasurementsGenerationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitEphemerisData": OrbitEphemeris.from_dict(obj["orbitEphemerisData"]) if obj.get("orbitEphemerisData") is not None else None,
            "measurementsRequests": [MeasurementRequest.from_dict(_item) for _item in obj["measurementsRequests"]] if obj.get("measurementsRequests") is not None else None,
            "data": obj.get("data")
        })
        return _obj


