# coding: utf-8

"""
    Measurements Generation API

    Measurements Generation API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.azimuth_elevation_measurements import AzimuthElevationMeasurements
from spacetower_orbit_extrapolation_python_client.models.gps_nmea_measurements import GpsNmeaMeasurements
from spacetower_orbit_extrapolation_python_client.models.position_measurements import PositionMeasurements
from spacetower_orbit_extrapolation_python_client.models.position_velocity_measurements import PositionVelocityMeasurements
from spacetower_orbit_extrapolation_python_client.models.ra_dec_measurements import RaDecMeasurements
from typing import Optional, Set
from typing_extensions import Self

class MeasurementsGenerationResult(BaseModel):
    """
    Output containing the generated measurement samples
    """ # noqa: E501
    azimuth_elevation_measurements: Optional[AzimuthElevationMeasurements] = Field(default=None, alias="azimuthElevationMeasurements")
    gps_nmea_measurements: Optional[GpsNmeaMeasurements] = Field(default=None, alias="gpsNmeaMeasurements")
    position_measurements: Optional[PositionMeasurements] = Field(default=None, alias="positionMeasurements")
    position_velocity_measurements: Optional[PositionVelocityMeasurements] = Field(default=None, alias="positionVelocityMeasurements")
    ra_dec_measurements: Optional[RaDecMeasurements] = Field(default=None, alias="raDecMeasurements")
    data: Optional[Dict[str, StrictStr]] = Field(default=None, description="References to the data used during the computation")
    __properties: ClassVar[List[str]] = ["azimuthElevationMeasurements", "gpsNmeaMeasurements", "positionMeasurements", "positionVelocityMeasurements", "raDecMeasurements", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeasurementsGenerationResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of azimuth_elevation_measurements
        if self.azimuth_elevation_measurements:
            _dict['azimuthElevationMeasurements'] = self.azimuth_elevation_measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gps_nmea_measurements
        if self.gps_nmea_measurements:
            _dict['gpsNmeaMeasurements'] = self.gps_nmea_measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_measurements
        if self.position_measurements:
            _dict['positionMeasurements'] = self.position_measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_velocity_measurements
        if self.position_velocity_measurements:
            _dict['positionVelocityMeasurements'] = self.position_velocity_measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ra_dec_measurements
        if self.ra_dec_measurements:
            _dict['raDecMeasurements'] = self.ra_dec_measurements.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeasurementsGenerationResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "azimuthElevationMeasurements": AzimuthElevationMeasurements.from_dict(obj["azimuthElevationMeasurements"]) if obj.get("azimuthElevationMeasurements") is not None else None,
            "gpsNmeaMeasurements": GpsNmeaMeasurements.from_dict(obj["gpsNmeaMeasurements"]) if obj.get("gpsNmeaMeasurements") is not None else None,
            "positionMeasurements": PositionMeasurements.from_dict(obj["positionMeasurements"]) if obj.get("positionMeasurements") is not None else None,
            "positionVelocityMeasurements": PositionVelocityMeasurements.from_dict(obj["positionVelocityMeasurements"]) if obj.get("positionVelocityMeasurements") is not None else None,
            "raDecMeasurements": RaDecMeasurements.from_dict(obj["raDecMeasurements"]) if obj.get("raDecMeasurements") is not None else None,
            "data": obj.get("data")
        })
        return _obj


