# coding: utf-8

"""
    Measurements Generation API

    Measurements Generation API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.earth_centered_frame_id import EarthCenteredFrameId
from spacetower_orbit_extrapolation_python_client.models.measurement_request import MeasurementRequest
from spacetower_orbit_extrapolation_python_client.models.measurement_type import MeasurementType
from spacetower_orbit_extrapolation_python_client.models.noise_frame_id import NoiseFrameId
from spacetower_orbit_extrapolation_python_client.models.position_correlation_coefficients import PositionCorrelationCoefficients
from spacetower_orbit_extrapolation_python_client.models.position_standard_deviation import PositionStandardDeviation
from spacetower_orbit_extrapolation_python_client.models.position_velocity_correlation_coefficients import PositionVelocityCorrelationCoefficients
from spacetower_orbit_extrapolation_python_client.models.velocity_correlation_coefficients import VelocityCorrelationCoefficients
from spacetower_orbit_extrapolation_python_client.models.velocity_standard_deviation import VelocityStandardDeviation
from typing import Optional, Set
from typing_extensions import Self

class PositionVelocityMeasurementsRequest(MeasurementRequest):
    """
    Request for generating a measurement sample consisting of position and velocity in a specified frame
    """ # noqa: E501
    frame_id: Optional[EarthCenteredFrameId] = Field(default=None, alias="frameId")
    position_standard_deviation: Optional[PositionStandardDeviation] = Field(default=None, alias="positionStandardDeviation")
    position_correlation_coefficients: Optional[PositionCorrelationCoefficients] = Field(default=None, alias="positionCorrelationCoefficients")
    velocity_standard_deviation: Optional[VelocityStandardDeviation] = Field(default=None, alias="velocityStandardDeviation")
    velocity_correlation_coefficients: Optional[VelocityCorrelationCoefficients] = Field(default=None, alias="velocityCorrelationCoefficients")
    position_velocity_correlation_coefficients: Optional[PositionVelocityCorrelationCoefficients] = Field(default=None, alias="positionVelocityCorrelationCoefficients")
    noise_frame_id: Optional[NoiseFrameId] = Field(default=None, alias="noiseFrameId")
    __properties: ClassVar[List[str]] = ["measurementType", "frameId", "positionStandardDeviation", "positionCorrelationCoefficients", "velocityStandardDeviation", "velocityCorrelationCoefficients", "positionVelocityCorrelationCoefficients", "noiseFrameId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PositionVelocityMeasurementsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position_standard_deviation
        if self.position_standard_deviation:
            _dict['positionStandardDeviation'] = self.position_standard_deviation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_correlation_coefficients
        if self.position_correlation_coefficients:
            _dict['positionCorrelationCoefficients'] = self.position_correlation_coefficients.to_dict()
        # override the default output from pydantic by calling `to_dict()` of velocity_standard_deviation
        if self.velocity_standard_deviation:
            _dict['velocityStandardDeviation'] = self.velocity_standard_deviation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of velocity_correlation_coefficients
        if self.velocity_correlation_coefficients:
            _dict['velocityCorrelationCoefficients'] = self.velocity_correlation_coefficients.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_velocity_correlation_coefficients
        if self.position_velocity_correlation_coefficients:
            _dict['positionVelocityCorrelationCoefficients'] = self.position_velocity_correlation_coefficients.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PositionVelocityMeasurementsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "measurementType": obj.get("measurementType"),
            "frameId": obj.get("frameId"),
            "positionStandardDeviation": PositionStandardDeviation.from_dict(obj["positionStandardDeviation"]) if obj.get("positionStandardDeviation") is not None else None,
            "positionCorrelationCoefficients": PositionCorrelationCoefficients.from_dict(obj["positionCorrelationCoefficients"]) if obj.get("positionCorrelationCoefficients") is not None else None,
            "velocityStandardDeviation": VelocityStandardDeviation.from_dict(obj["velocityStandardDeviation"]) if obj.get("velocityStandardDeviation") is not None else None,
            "velocityCorrelationCoefficients": VelocityCorrelationCoefficients.from_dict(obj["velocityCorrelationCoefficients"]) if obj.get("velocityCorrelationCoefficients") is not None else None,
            "positionVelocityCorrelationCoefficients": PositionVelocityCorrelationCoefficients.from_dict(obj["positionVelocityCorrelationCoefficients"]) if obj.get("positionVelocityCorrelationCoefficients") is not None else None,
            "noiseFrameId": obj.get("noiseFrameId")
        })
        return _obj


