# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.isotropic_drag_properties_single_coefficient import IsotropicDragPropertiesSingleCoefficient
from spacetower_orbit_extrapolation_python_client.models.isotropic_reflection_properties_single_coefficient import IsotropicReflectionPropertiesSingleCoefficient
from spacetower_orbit_extrapolation_python_client.models.propulsion_system import PropulsionSystem
from spacetower_orbit_extrapolation_python_client.models.solar_array_system import SolarArraySystem
from spacetower_orbit_extrapolation_python_client.models.space_object import SpaceObject
from spacetower_orbit_extrapolation_python_client.models.space_object_type import SpaceObjectType
from typing import Optional, Set
from typing_extensions import Self

class PointSpacecraft(SpaceObject):
    """
    Spherical spacecraft
    """ # noqa: E501
    drag_properties: Optional[IsotropicDragPropertiesSingleCoefficient] = Field(default=None, alias="dragProperties")
    reflection_properties: Optional[IsotropicReflectionPropertiesSingleCoefficient] = Field(default=None, alias="reflectionProperties")
    __properties: ClassVar[List[str]] = ["mass", "solarArraySystem", "propulsionSystem", "spaceObjectType", "dragProperties", "reflectionProperties"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PointSpacecraft from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of solar_array_system
        if self.solar_array_system:
            _dict['solarArraySystem'] = self.solar_array_system.to_dict()
        # override the default output from pydantic by calling `to_dict()` of propulsion_system
        if self.propulsion_system:
            _dict['propulsionSystem'] = self.propulsion_system.to_dict()
        # override the default output from pydantic by calling `to_dict()` of drag_properties
        if self.drag_properties:
            _dict['dragProperties'] = self.drag_properties.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reflection_properties
        if self.reflection_properties:
            _dict['reflectionProperties'] = self.reflection_properties.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PointSpacecraft from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mass": obj.get("mass") if obj.get("mass") is not None else 1000,
            "solarArraySystem": SolarArraySystem.from_dict(obj["solarArraySystem"]) if obj.get("solarArraySystem") is not None else None,
            "propulsionSystem": PropulsionSystem.from_dict(obj["propulsionSystem"]) if obj.get("propulsionSystem") is not None else None,
            "spaceObjectType": obj.get("spaceObjectType"),
            "dragProperties": IsotropicDragPropertiesSingleCoefficient.from_dict(obj["dragProperties"]) if obj.get("dragProperties") is not None else None,
            "reflectionProperties": IsotropicReflectionPropertiesSingleCoefficient.from_dict(obj["reflectionProperties"]) if obj.get("reflectionProperties") is not None else None
        })
        return _obj


