# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.drag_properties import DragProperties
from spacetower_orbit_extrapolation_python_client.models.drag_property_type import DragPropertyType
from typing import Optional, Set
from typing_extensions import Self

class IsotropicDragPropertiesSingleCoefficient(DragProperties):
    """
    Drag properties independent of the direction with the only drag coefficient
    """ # noqa: E501
    drag_coefficient: Optional[Union[StrictFloat, StrictInt]] = Field(default=2.2, description="Dimensionless coefficient. Units [-]", alias="dragCoefficient")
    drag_cross_section: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Units [m^2]", alias="dragCrossSection")
    __properties: ClassVar[List[str]] = ["dragPropertyType", "dragCoefficient", "dragCrossSection"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IsotropicDragPropertiesSingleCoefficient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IsotropicDragPropertiesSingleCoefficient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dragPropertyType": obj.get("dragPropertyType"),
            "dragCoefficient": obj.get("dragCoefficient") if obj.get("dragCoefficient") is not None else 2.2,
            "dragCrossSection": obj.get("dragCrossSection")
        })
        return _obj


