# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.attitude_sequence import AttitudeSequence
from spacetower_orbit_extrapolation_python_client.models.battery_model import BatteryModel
from spacetower_orbit_extrapolation_python_client.models.covariance_matrix import CovarianceMatrix
from spacetower_orbit_extrapolation_python_client.models.ephemeris_generation_request import EphemerisGenerationRequest
from spacetower_orbit_extrapolation_python_client.models.event_generation_request import EventGenerationRequest
from spacetower_orbit_extrapolation_python_client.models.integrator_configuration import IntegratorConfiguration
from spacetower_orbit_extrapolation_python_client.models.maneuver_schedule import ManeuverSchedule
from spacetower_orbit_extrapolation_python_client.models.orbit import Orbit
from spacetower_orbit_extrapolation_python_client.models.perturbations_configuration import PerturbationsConfiguration
from spacetower_orbit_extrapolation_python_client.models.reference_frames_configuration import ReferenceFramesConfiguration
from spacetower_orbit_extrapolation_python_client.models.space_object import SpaceObject
from typing import Optional, Set
from typing_extensions import Self

class NumericalExtrapolationRequest(BaseModel):
    """
    Configuration for extrapolation based on special perturbations method
    """ # noqa: E501
    target_date: str = Field(description="timescale UTC", alias="targetDate")
    initial_orbit: Orbit = Field(alias="initialOrbit")
    initial_covariance_matrix: Optional[CovarianceMatrix] = Field(default=None, alias="initialCovarianceMatrix")
    attitude_sequence: Optional[AttitudeSequence] = Field(default=None, alias="attitudeSequence")
    spacecraft: Optional[SpaceObject] = None
    battery_model: Optional[BatteryModel] = Field(default=None, alias="batteryModel")
    reference_frames_configuration: Optional[ReferenceFramesConfiguration] = Field(default=None, alias="referenceFramesConfiguration")
    perturbations_configuration: Optional[PerturbationsConfiguration] = Field(default=None, alias="perturbationsConfiguration")
    maneuver_schedule: Optional[ManeuverSchedule] = Field(default=None, alias="maneuverSchedule")
    integrator_configuration: Optional[IntegratorConfiguration] = Field(default=None, alias="integratorConfiguration")
    event_generation_requests: Optional[List[EventGenerationRequest]] = Field(default=None, alias="eventGenerationRequests")
    ephemeris_generation_requests: Optional[List[EphemerisGenerationRequest]] = Field(default=None, alias="ephemerisGenerationRequests")
    __properties: ClassVar[List[str]] = ["targetDate", "initialOrbit", "initialCovarianceMatrix", "attitudeSequence", "spacecraft", "batteryModel", "referenceFramesConfiguration", "perturbationsConfiguration", "maneuverSchedule", "integratorConfiguration", "eventGenerationRequests", "ephemerisGenerationRequests"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalExtrapolationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of initial_orbit
        if self.initial_orbit:
            _dict['initialOrbit'] = self.initial_orbit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_covariance_matrix
        if self.initial_covariance_matrix:
            _dict['initialCovarianceMatrix'] = self.initial_covariance_matrix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attitude_sequence
        if self.attitude_sequence:
            _dict['attitudeSequence'] = self.attitude_sequence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spacecraft
        if self.spacecraft:
            _dict['spacecraft'] = self.spacecraft.to_dict()
        # override the default output from pydantic by calling `to_dict()` of battery_model
        if self.battery_model:
            _dict['batteryModel'] = self.battery_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reference_frames_configuration
        if self.reference_frames_configuration:
            _dict['referenceFramesConfiguration'] = self.reference_frames_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of perturbations_configuration
        if self.perturbations_configuration:
            _dict['perturbationsConfiguration'] = self.perturbations_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maneuver_schedule
        if self.maneuver_schedule:
            _dict['maneuverSchedule'] = self.maneuver_schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integrator_configuration
        if self.integrator_configuration:
            _dict['integratorConfiguration'] = self.integrator_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in event_generation_requests (list)
        _items = []
        if self.event_generation_requests:
            for _item in self.event_generation_requests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['eventGenerationRequests'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ephemeris_generation_requests (list)
        _items = []
        if self.ephemeris_generation_requests:
            for _item in self.ephemeris_generation_requests:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ephemerisGenerationRequests'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalExtrapolationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "targetDate": obj.get("targetDate"),
            "initialOrbit": Orbit.from_dict(obj["initialOrbit"]) if obj.get("initialOrbit") is not None else None,
            "initialCovarianceMatrix": CovarianceMatrix.from_dict(obj["initialCovarianceMatrix"]) if obj.get("initialCovarianceMatrix") is not None else None,
            "attitudeSequence": AttitudeSequence.from_dict(obj["attitudeSequence"]) if obj.get("attitudeSequence") is not None else None,
            "spacecraft": SpaceObject.from_dict(obj["spacecraft"]) if obj.get("spacecraft") is not None else None,
            "batteryModel": BatteryModel.from_dict(obj["batteryModel"]) if obj.get("batteryModel") is not None else None,
            "referenceFramesConfiguration": ReferenceFramesConfiguration.from_dict(obj["referenceFramesConfiguration"]) if obj.get("referenceFramesConfiguration") is not None else None,
            "perturbationsConfiguration": PerturbationsConfiguration.from_dict(obj["perturbationsConfiguration"]) if obj.get("perturbationsConfiguration") is not None else None,
            "maneuverSchedule": ManeuverSchedule.from_dict(obj["maneuverSchedule"]) if obj.get("maneuverSchedule") is not None else None,
            "integratorConfiguration": IntegratorConfiguration.from_dict(obj["integratorConfiguration"]) if obj.get("integratorConfiguration") is not None else None,
            "eventGenerationRequests": [EventGenerationRequest.from_dict(_item) for _item in obj["eventGenerationRequests"]] if obj.get("eventGenerationRequests") is not None else None,
            "ephemerisGenerationRequests": [EphemerisGenerationRequest.from_dict(_item) for _item in obj["ephemerisGenerationRequests"]] if obj.get("ephemerisGenerationRequests") is not None else None
        })
        return _obj


