# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.celestial_body_configuration import CelestialBodyConfiguration
from spacetower_orbit_extrapolation_python_client.models.event_detection_type import EventDetectionType
from spacetower_orbit_extrapolation_python_client.models.event_generation_request import EventGenerationRequest
from spacetower_orbit_extrapolation_python_client.models.event_types import EventTypes
from typing import Optional, Set
from typing_extensions import Self

class OrbitalEventRequest(EventGenerationRequest):
    """
    Select several orbital events that can be logged during the extrapolation
    """ # noqa: E501
    celestial_body_configuration: Optional[CelestialBodyConfiguration] = Field(default=None, alias="celestialBodyConfiguration")
    orbital_event_type: List[EventTypes] = Field(alias="orbitalEventType")
    __properties: ClassVar[List[str]] = ["eventType", "eventDetectionType", "celestialBodyConfiguration", "orbitalEventType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrbitalEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of celestial_body_configuration
        if self.celestial_body_configuration:
            _dict['celestialBodyConfiguration'] = self.celestial_body_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrbitalEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "eventType": obj.get("eventType"),
            "eventDetectionType": obj.get("eventDetectionType"),
            "celestialBodyConfiguration": CelestialBodyConfiguration.from_dict(obj["celestialBodyConfiguration"]) if obj.get("celestialBodyConfiguration") is not None else None,
            "orbitalEventType": obj.get("orbitalEventType")
        })
        return _obj


