# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.field_description import FieldDescription
from spacetower_orbit_extrapolation_python_client.models.inertial_frame_identifier import InertialFrameIdentifier
from spacetower_orbit_extrapolation_python_client.models.osculating_to_mean_configuration import OsculatingToMeanConfiguration
from typing import Optional, Set
from typing_extensions import Self

class MeanOrbitEphemeris(BaseModel):
    """
    Ephemeris of mean orbital elements in an inertial frame. Available theories are DSST with 6x0 Earth potential and SGP4
    """ # noqa: E501
    dates: List[str]
    data: List[List[Union[StrictFloat, StrictInt]]]
    description: Optional[List[FieldDescription]] = None
    frame: InertialFrameIdentifier
    mean_elements_theory: OsculatingToMeanConfiguration = Field(alias="meanElementsTheory")
    __properties: ClassVar[List[str]] = ["dates", "data", "description", "frame", "meanElementsTheory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeanOrbitEphemeris from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeanOrbitEphemeris from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dates": obj.get("dates"),
            "data": obj.get("data"),
            "description": [FieldDescription.from_dict(_item) for _item in obj["description"]] if obj.get("description") is not None else None,
            "frame": obj.get("frame"),
            "meanElementsTheory": obj.get("meanElementsTheory")
        })
        return _obj


