# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Thruster(BaseModel):
    """
    Propulsion unit for finite duration burns (non-impulsive)
    """ # noqa: E501
    thrust: Union[StrictFloat, StrictInt] = Field(description="Units [N]")
    specific_impulse: Union[StrictFloat, StrictInt] = Field(description="Units [s]", alias="specificImpulse")
    thruster_axis_x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="X component of thruster axis direction in satellite body frame", alias="thrusterAxisX")
    thruster_axis_y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Y component of thruster axis direction in satellite body frame", alias="thrusterAxisY")
    thruster_axis_z: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Z component of thruster axis direction in satellite body frame", alias="thrusterAxisZ")
    __properties: ClassVar[List[str]] = ["thrust", "specificImpulse", "thrusterAxisX", "thrusterAxisY", "thrusterAxisZ"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Thruster from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Thruster from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "thrust": obj.get("thrust"),
            "specificImpulse": obj.get("specificImpulse"),
            "thrusterAxisX": obj.get("thrusterAxisX"),
            "thrusterAxisY": obj.get("thrusterAxisY"),
            "thrusterAxisZ": obj.get("thrusterAxisZ")
        })
        return _obj


