# spacetower_orbit_extrapolation_python_client
Orbit Extrapolation API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.5
- Package version: 1.1.5
- Generator version: 7.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import spacetower_orbit_extrapolation_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import spacetower_orbit_extrapolation_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import spacetower_orbit_extrapolation_python_client
from spacetower_orbit_extrapolation_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://orbit-extrapolation.exoops.57.128.40.142.sslip.io
# See configuration.py for a list of all supported configuration parameters.
configuration = spacetower_orbit_extrapolation_python_client.Configuration(
    host = "http://orbit-extrapolation.exoops.57.128.40.142.sslip.io"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = spacetower_orbit_extrapolation_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with spacetower_orbit_extrapolation_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = spacetower_orbit_extrapolation_python_client.DefaultApi(api_client)
    numerical_extrapolation_request = spacetower_orbit_extrapolation_python_client.NumericalExtrapolationRequest() # NumericalExtrapolationRequest |  (optional)

    try:
        # Numerical extrapolation
        api_response = api_instance.compute_numerical_extrapolation(numerical_extrapolation_request=numerical_extrapolation_request)
        print("The response of DefaultApi->compute_numerical_extrapolation:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->compute_numerical_extrapolation: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://orbit-extrapolation.exoops.57.128.40.142.sslip.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**compute_numerical_extrapolation**](docs/DefaultApi.md#compute_numerical_extrapolation) | **POST** /extrapolation/numerical | Numerical extrapolation
*DefaultApi* | [**compute_tle_extrapolation**](docs/DefaultApi.md#compute_tle_extrapolation) | **POST** /extrapolation/tle | TLE extrapolation


## Documentation For Models

 - [AtmosphereModel](docs/AtmosphereModel.md)
 - [AtmosphereType](docs/AtmosphereType.md)
 - [AtmosphericDragPerturbation](docs/AtmosphericDragPerturbation.md)
 - [AttitudeBasedFiniteThrustSchedule](docs/AttitudeBasedFiniteThrustSchedule.md)
 - [AttitudeEphemeris](docs/AttitudeEphemeris.md)
 - [AttitudeEphemerisRequest](docs/AttitudeEphemerisRequest.md)
 - [AttitudeLaw](docs/AttitudeLaw.md)
 - [AttitudeLawType](docs/AttitudeLawType.md)
 - [AttitudeRepresentationType](docs/AttitudeRepresentationType.md)
 - [AttitudeSequence](docs/AttitudeSequence.md)
 - [AttitudeSequenceType](docs/AttitudeSequenceType.md)
 - [BatteryModel](docs/BatteryModel.md)
 - [BatteryPowerEphemeris](docs/BatteryPowerEphemeris.md)
 - [BatteryPowerEphemerisRequest](docs/BatteryPowerEphemerisRequest.md)
 - [BoxObject](docs/BoxObject.md)
 - [CardanAngleEphemeris](docs/CardanAngleEphemeris.md)
 - [CartesianCovarianceAllowedFrame](docs/CartesianCovarianceAllowedFrame.md)
 - [CartesianCovarianceEphemeris](docs/CartesianCovarianceEphemeris.md)
 - [CartesianCovarianceMatrix](docs/CartesianCovarianceMatrix.md)
 - [CartesianOrbit](docs/CartesianOrbit.md)
 - [CelestialBody](docs/CelestialBody.md)
 - [CelestialBodyConfiguration](docs/CelestialBodyConfiguration.md)
 - [CelestialBodyName](docs/CelestialBodyName.md)
 - [CircularFieldOfView](docs/CircularFieldOfView.md)
 - [CircularOrbit](docs/CircularOrbit.md)
 - [ClosestApproachEventLog](docs/ClosestApproachEventLog.md)
 - [ConjunctionEventRequest](docs/ConjunctionEventRequest.md)
 - [ConjunctionEventTypes](docs/ConjunctionEventTypes.md)
 - [CovarianceMatrix](docs/CovarianceMatrix.md)
 - [DateTriggeredAttitude](docs/DateTriggeredAttitude.md)
 - [DateTriggeredAttitudeSequence](docs/DateTriggeredAttitudeSequence.md)
 - [DatedLofFiniteThrustDirection](docs/DatedLofFiniteThrustDirection.md)
 - [DatedLofImpulse](docs/DatedLofImpulse.md)
 - [EarthCenteredFrameType](docs/EarthCenteredFrameType.md)
 - [EarthFixedFrameIdentifier](docs/EarthFixedFrameIdentifier.md)
 - [EarthOrientedManeuverAttitudeLaw](docs/EarthOrientedManeuverAttitudeLaw.md)
 - [EarthPotentialPerturbation](docs/EarthPotentialPerturbation.md)
 - [EllipsoidIdentifier](docs/EllipsoidIdentifier.md)
 - [EphemerisGenerationRequest](docs/EphemerisGenerationRequest.md)
 - [EphemerisType](docs/EphemerisType.md)
 - [EquinoctialOrbit](docs/EquinoctialOrbit.md)
 - [EventDetectionType](docs/EventDetectionType.md)
 - [EventGenerationRequest](docs/EventGenerationRequest.md)
 - [EventTypes](docs/EventTypes.md)
 - [FieldDescription](docs/FieldDescription.md)
 - [FieldOfView](docs/FieldOfView.md)
 - [FieldOfViewEventLog](docs/FieldOfViewEventLog.md)
 - [FieldOfViewEventRequest](docs/FieldOfViewEventRequest.md)
 - [FieldOfViewEventTypes](docs/FieldOfViewEventTypes.md)
 - [FieldOfViewType](docs/FieldOfViewType.md)
 - [FiniteThrustDefinition](docs/FiniteThrustDefinition.md)
 - [FixedIntegratorType](docs/FixedIntegratorType.md)
 - [FixedStepIntegratorConfiguration](docs/FixedStepIntegratorConfiguration.md)
 - [FrameIdentifier](docs/FrameIdentifier.md)
 - [GeodeticEphemeris](docs/GeodeticEphemeris.md)
 - [GeodeticEphemerisRequest](docs/GeodeticEphemerisRequest.md)
 - [GroundStation](docs/GroundStation.md)
 - [HarrisPriesterAtmosphere](docs/HarrisPriesterAtmosphere.md)
 - [InertialFrameIdentifier](docs/InertialFrameIdentifier.md)
 - [InitialOrbitType](docs/InitialOrbitType.md)
 - [IntegratorConfiguration](docs/IntegratorConfiguration.md)
 - [IntegratorType](docs/IntegratorType.md)
 - [IsotropicObject](docs/IsotropicObject.md)
 - [KeplerianOrbit](docs/KeplerianOrbit.md)
 - [LofAttitudeLaw](docs/LofAttitudeLaw.md)
 - [LofBasedFiniteThrustSequence](docs/LofBasedFiniteThrustSequence.md)
 - [LofBasedImpulsiveSequence](docs/LofBasedImpulsiveSequence.md)
 - [LofBasedManeuverSchedule](docs/LofBasedManeuverSchedule.md)
 - [LofBasedManeuverSequence](docs/LofBasedManeuverSequence.md)
 - [LofBasedManeuverSequenceType](docs/LofBasedManeuverSequenceType.md)
 - [LofType](docs/LofType.md)
 - [ManeuverDirectionType](docs/ManeuverDirectionType.md)
 - [ManeuverSchedule](docs/ManeuverSchedule.md)
 - [ManeuverScheduleType](docs/ManeuverScheduleType.md)
 - [MassEphemeris](docs/MassEphemeris.md)
 - [MassEphemerisRequest](docs/MassEphemerisRequest.md)
 - [MeanOrbitEphemeris](docs/MeanOrbitEphemeris.md)
 - [MeanOrbitEphemerisRequest](docs/MeanOrbitEphemerisRequest.md)
 - [MeanOsculatingOrbitType](docs/MeanOsculatingOrbitType.md)
 - [Moon](docs/Moon.md)
 - [NadirPointingLaw](docs/NadirPointingLaw.md)
 - [NrlMsise00Atmosphere](docs/NrlMsise00Atmosphere.md)
 - [NumericalExtrapolationRequest](docs/NumericalExtrapolationRequest.md)
 - [NumericalExtrapolationResult](docs/NumericalExtrapolationResult.md)
 - [OemRequest](docs/OemRequest.md)
 - [Orbit](docs/Orbit.md)
 - [OrbitDataMessageFileFormat](docs/OrbitDataMessageFileFormat.md)
 - [OrbitalCovarianceEphemeris](docs/OrbitalCovarianceEphemeris.md)
 - [OrbitalCovarianceEphemerisRequest](docs/OrbitalCovarianceEphemerisRequest.md)
 - [OrbitalCovarianceMatrix](docs/OrbitalCovarianceMatrix.md)
 - [OrbitalEventLog](docs/OrbitalEventLog.md)
 - [OrbitalEventRequest](docs/OrbitalEventRequest.md)
 - [OrbitalEventTypes](docs/OrbitalEventTypes.md)
 - [OrbitalParameterType](docs/OrbitalParameterType.md)
 - [OsculatingOrbitEphemeris](docs/OsculatingOrbitEphemeris.md)
 - [OsculatingOrbitEphemerisRequest](docs/OsculatingOrbitEphemerisRequest.md)
 - [OsculatingToMeanConfiguration](docs/OsculatingToMeanConfiguration.md)
 - [Perturbation](docs/Perturbation.md)
 - [PerturbationType](docs/PerturbationType.md)
 - [PerturbationsConfiguration](docs/PerturbationsConfiguration.md)
 - [PositionAngleType](docs/PositionAngleType.md)
 - [PositionVelocityCovarianceEphemerisRequest](docs/PositionVelocityCovarianceEphemerisRequest.md)
 - [PositionVelocityEphemeris](docs/PositionVelocityEphemeris.md)
 - [PositionVelocityEphemerisRequest](docs/PositionVelocityEphemerisRequest.md)
 - [ProblemDetail](docs/ProblemDetail.md)
 - [PropulsionSystem](docs/PropulsionSystem.md)
 - [QuaternionEphemeris](docs/QuaternionEphemeris.md)
 - [RadiationCoefficients](docs/RadiationCoefficients.md)
 - [RadiationCoefficientsType](docs/RadiationCoefficientsType.md)
 - [ReferenceFramesConfiguration](docs/ReferenceFramesConfiguration.md)
 - [ReflectionAbsorptionCoefficients](docs/ReflectionAbsorptionCoefficients.md)
 - [ShadowModelType](docs/ShadowModelType.md)
 - [SingleRadiationCoefficient](docs/SingleRadiationCoefficient.md)
 - [SolarArrayGeometry](docs/SolarArrayGeometry.md)
 - [SolarArraySystem](docs/SolarArraySystem.md)
 - [SolarRadiationPressurePerturbation](docs/SolarRadiationPressurePerturbation.md)
 - [SolidTidesPerturbation](docs/SolidTidesPerturbation.md)
 - [SpaceObject](docs/SpaceObject.md)
 - [SpaceObjectType](docs/SpaceObjectType.md)
 - [StationEventRequest](docs/StationEventRequest.md)
 - [StationEventTypes](docs/StationEventTypes.md)
 - [StationVisibilityEventLog](docs/StationVisibilityEventLog.md)
 - [Sun](docs/Sun.md)
 - [SunEnhancedManeuverAttitudeLaw](docs/SunEnhancedManeuverAttitudeLaw.md)
 - [SunPointingLaw](docs/SunPointingLaw.md)
 - [TLE](docs/TLE.md)
 - [TargetCelestialBody](docs/TargetCelestialBody.md)
 - [ThirdBodiesGravityPerturbation](docs/ThirdBodiesGravityPerturbation.md)
 - [ThrustVectorEphemeris](docs/ThrustVectorEphemeris.md)
 - [ThrustVectorEphemerisRequest](docs/ThrustVectorEphemerisRequest.md)
 - [Thruster](docs/Thruster.md)
 - [TimeSpan](docs/TimeSpan.md)
 - [TimestampedOutputData](docs/TimestampedOutputData.md)
 - [TleExtrapolationRequest](docs/TleExtrapolationRequest.md)
 - [TleExtrapolationResult](docs/TleExtrapolationResult.md)
 - [TwoLineElementOrbit](docs/TwoLineElementOrbit.md)
 - [VariableStepIntegratorConfiguration](docs/VariableStepIntegratorConfiguration.md)
 - [VariableStepIntegratorType](docs/VariableStepIntegratorType.md)
 - [Vector3D](docs/Vector3D.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author




