# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.conjunction_event_types import ConjunctionEventTypes
from spacetower_orbit_extrapolation_python_client.models.vector3_d import Vector3D
from typing import Optional, Set
from typing_extensions import Self

class ClosestApproachEventLog(BaseModel):
    """
    Closest approach event summary 
    """ # noqa: E501
    utc_date: StrictStr = Field(description="The event's UTC date", alias="utcDate")
    event_type: ConjunctionEventTypes = Field(alias="eventType")
    secondary_name: StrictStr = Field(description="Name of the secondary object", alias="secondaryName")
    miss_distance: Union[StrictFloat, StrictInt] = Field(description="The norm of the relative position vector at TCA", alias="missDistance")
    relative_position_vector_in_qsw: Optional[Vector3D] = Field(default=None, alias="relativePositionVectorInQsw")
    relative_velocity_vector_in_qsw: Optional[Vector3D] = Field(default=None, alias="relativeVelocityVectorInQsw")
    __properties: ClassVar[List[str]] = ["utcDate", "eventType", "secondaryName", "missDistance", "relativePositionVectorInQsw", "relativeVelocityVectorInQsw"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClosestApproachEventLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of relative_position_vector_in_qsw
        if self.relative_position_vector_in_qsw:
            _dict['relativePositionVectorInQsw'] = self.relative_position_vector_in_qsw.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relative_velocity_vector_in_qsw
        if self.relative_velocity_vector_in_qsw:
            _dict['relativeVelocityVectorInQsw'] = self.relative_velocity_vector_in_qsw.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClosestApproachEventLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "utcDate": obj.get("utcDate"),
            "eventType": obj.get("eventType"),
            "secondaryName": obj.get("secondaryName"),
            "missDistance": obj.get("missDistance"),
            "relativePositionVectorInQsw": Vector3D.from_dict(obj["relativePositionVectorInQsw"]) if obj.get("relativePositionVectorInQsw") is not None else None,
            "relativeVelocityVectorInQsw": Vector3D.from_dict(obj["relativeVelocityVectorInQsw"]) if obj.get("relativeVelocityVectorInQsw") is not None else None
        })
        return _obj


