# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.dated_lof_impulse import DatedLofImpulse
from spacetower_orbit_extrapolation_python_client.models.lof_based_maneuver_sequence import LofBasedManeuverSequence
from spacetower_orbit_extrapolation_python_client.models.lof_based_maneuver_sequence_type import LofBasedManeuverSequenceType
from typing import Optional, Set
from typing_extensions import Self

class LofBasedImpulsiveSequence(LofBasedManeuverSequence):
    """
    LofBasedImpulsiveSequence
    """ # noqa: E501
    dated_impulses: Optional[List[DatedLofImpulse]] = Field(default=None, alias="datedImpulses")
    __properties: ClassVar[List[str]] = ["maneuverSequenceType", "datedImpulses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LofBasedImpulsiveSequence from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dated_impulses (list)
        _items = []
        if self.dated_impulses:
            for _item in self.dated_impulses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['datedImpulses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LofBasedImpulsiveSequence from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "maneuverSequenceType": obj.get("maneuverSequenceType"),
            "datedImpulses": [DatedLofImpulse.from_dict(_item) for _item in obj["datedImpulses"]] if obj.get("datedImpulses") is not None else None
        })
        return _obj


