# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.1.5
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.attitude_ephemeris import AttitudeEphemeris
from spacetower_orbit_extrapolation_python_client.models.battery_power_ephemeris import BatteryPowerEphemeris
from spacetower_orbit_extrapolation_python_client.models.cartesian_covariance_ephemeris import CartesianCovarianceEphemeris
from spacetower_orbit_extrapolation_python_client.models.closest_approach_event_log import ClosestApproachEventLog
from spacetower_orbit_extrapolation_python_client.models.field_of_view_event_log import FieldOfViewEventLog
from spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris import GeodeticEphemeris
from spacetower_orbit_extrapolation_python_client.models.mass_ephemeris import MassEphemeris
from spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris import MeanOrbitEphemeris
from spacetower_orbit_extrapolation_python_client.models.orbital_covariance_ephemeris import OrbitalCovarianceEphemeris
from spacetower_orbit_extrapolation_python_client.models.orbital_event_log import OrbitalEventLog
from spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris import OsculatingOrbitEphemeris
from spacetower_orbit_extrapolation_python_client.models.position_velocity_ephemeris import PositionVelocityEphemeris
from spacetower_orbit_extrapolation_python_client.models.station_visibility_event_log import StationVisibilityEventLog
from spacetower_orbit_extrapolation_python_client.models.thrust_vector_ephemeris import ThrustVectorEphemeris
from typing import Optional, Set
from typing_extensions import Self

class NumericalExtrapolationResult(BaseModel):
    """
    NumericalExtrapolationResult
    """ # noqa: E501
    attitude_ephemeris: Optional[AttitudeEphemeris] = Field(default=None, alias="attitudeEphemeris")
    battery_power_ephemeris: Optional[BatteryPowerEphemeris] = Field(default=None, alias="batteryPowerEphemeris")
    thrust_vector_ephemeris: Optional[ThrustVectorEphemeris] = Field(default=None, alias="thrustVectorEphemeris")
    mass_ephemeris: Optional[MassEphemeris] = Field(default=None, alias="massEphemeris")
    osculating_orbit_ephemeris: Optional[OsculatingOrbitEphemeris] = Field(default=None, alias="osculatingOrbitEphemeris")
    mean_orbit_ephemeris: Optional[MeanOrbitEphemeris] = Field(default=None, alias="meanOrbitEphemeris")
    geodetic_ephemeris: Optional[GeodeticEphemeris] = Field(default=None, alias="geodeticEphemeris")
    position_velocity_ephemeris: Optional[PositionVelocityEphemeris] = Field(default=None, alias="positionVelocityEphemeris")
    cartesian_covariance_ephemeris: Optional[CartesianCovarianceEphemeris] = Field(default=None, alias="cartesianCovarianceEphemeris")
    orbital_covariance_ephemeris: Optional[OrbitalCovarianceEphemeris] = Field(default=None, alias="orbitalCovarianceEphemeris")
    orbital_event_logs: Optional[List[OrbitalEventLog]] = Field(default=None, description="The computed orbital elements ephemeris", alias="orbitalEventLogs")
    station_event_logs: Optional[List[StationVisibilityEventLog]] = Field(default=None, description="The computed orbital elements ephemeris", alias="stationEventLogs")
    field_of_view_event_logs: Optional[List[FieldOfViewEventLog]] = Field(default=None, description="The computed field of view events from on-board sensors", alias="fieldOfViewEventLogs")
    closest_approach_event_logs: Optional[List[ClosestApproachEventLog]] = Field(default=None, description="The computed conjunction events", alias="closestApproachEventLogs")
    __properties: ClassVar[List[str]] = ["attitudeEphemeris", "batteryPowerEphemeris", "thrustVectorEphemeris", "massEphemeris", "osculatingOrbitEphemeris", "meanOrbitEphemeris", "geodeticEphemeris", "positionVelocityEphemeris", "cartesianCovarianceEphemeris", "orbitalCovarianceEphemeris", "orbitalEventLogs", "stationEventLogs", "fieldOfViewEventLogs", "closestApproachEventLogs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumericalExtrapolationResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attitude_ephemeris
        if self.attitude_ephemeris:
            _dict['attitudeEphemeris'] = self.attitude_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of battery_power_ephemeris
        if self.battery_power_ephemeris:
            _dict['batteryPowerEphemeris'] = self.battery_power_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thrust_vector_ephemeris
        if self.thrust_vector_ephemeris:
            _dict['thrustVectorEphemeris'] = self.thrust_vector_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mass_ephemeris
        if self.mass_ephemeris:
            _dict['massEphemeris'] = self.mass_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of osculating_orbit_ephemeris
        if self.osculating_orbit_ephemeris:
            _dict['osculatingOrbitEphemeris'] = self.osculating_orbit_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mean_orbit_ephemeris
        if self.mean_orbit_ephemeris:
            _dict['meanOrbitEphemeris'] = self.mean_orbit_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geodetic_ephemeris
        if self.geodetic_ephemeris:
            _dict['geodeticEphemeris'] = self.geodetic_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_velocity_ephemeris
        if self.position_velocity_ephemeris:
            _dict['positionVelocityEphemeris'] = self.position_velocity_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cartesian_covariance_ephemeris
        if self.cartesian_covariance_ephemeris:
            _dict['cartesianCovarianceEphemeris'] = self.cartesian_covariance_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbital_covariance_ephemeris
        if self.orbital_covariance_ephemeris:
            _dict['orbitalCovarianceEphemeris'] = self.orbital_covariance_ephemeris.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in orbital_event_logs (list)
        _items = []
        if self.orbital_event_logs:
            for _item in self.orbital_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orbitalEventLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in station_event_logs (list)
        _items = []
        if self.station_event_logs:
            for _item in self.station_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stationEventLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in field_of_view_event_logs (list)
        _items = []
        if self.field_of_view_event_logs:
            for _item in self.field_of_view_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fieldOfViewEventLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in closest_approach_event_logs (list)
        _items = []
        if self.closest_approach_event_logs:
            for _item in self.closest_approach_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['closestApproachEventLogs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumericalExtrapolationResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attitudeEphemeris": AttitudeEphemeris.from_dict(obj["attitudeEphemeris"]) if obj.get("attitudeEphemeris") is not None else None,
            "batteryPowerEphemeris": BatteryPowerEphemeris.from_dict(obj["batteryPowerEphemeris"]) if obj.get("batteryPowerEphemeris") is not None else None,
            "thrustVectorEphemeris": ThrustVectorEphemeris.from_dict(obj["thrustVectorEphemeris"]) if obj.get("thrustVectorEphemeris") is not None else None,
            "massEphemeris": MassEphemeris.from_dict(obj["massEphemeris"]) if obj.get("massEphemeris") is not None else None,
            "osculatingOrbitEphemeris": OsculatingOrbitEphemeris.from_dict(obj["osculatingOrbitEphemeris"]) if obj.get("osculatingOrbitEphemeris") is not None else None,
            "meanOrbitEphemeris": MeanOrbitEphemeris.from_dict(obj["meanOrbitEphemeris"]) if obj.get("meanOrbitEphemeris") is not None else None,
            "geodeticEphemeris": GeodeticEphemeris.from_dict(obj["geodeticEphemeris"]) if obj.get("geodeticEphemeris") is not None else None,
            "positionVelocityEphemeris": PositionVelocityEphemeris.from_dict(obj["positionVelocityEphemeris"]) if obj.get("positionVelocityEphemeris") is not None else None,
            "cartesianCovarianceEphemeris": CartesianCovarianceEphemeris.from_dict(obj["cartesianCovarianceEphemeris"]) if obj.get("cartesianCovarianceEphemeris") is not None else None,
            "orbitalCovarianceEphemeris": OrbitalCovarianceEphemeris.from_dict(obj["orbitalCovarianceEphemeris"]) if obj.get("orbitalCovarianceEphemeris") is not None else None,
            "orbitalEventLogs": [OrbitalEventLog.from_dict(_item) for _item in obj["orbitalEventLogs"]] if obj.get("orbitalEventLogs") is not None else None,
            "stationEventLogs": [StationVisibilityEventLog.from_dict(_item) for _item in obj["stationEventLogs"]] if obj.get("stationEventLogs") is not None else None,
            "fieldOfViewEventLogs": [FieldOfViewEventLog.from_dict(_item) for _item in obj["fieldOfViewEventLogs"]] if obj.get("fieldOfViewEventLogs") is not None else None,
            "closestApproachEventLogs": [ClosestApproachEventLog.from_dict(_item) for _item in obj["closestApproachEventLogs"]] if obj.get("closestApproachEventLogs") is not None else None
        })
        return _obj


