# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from spacetower_orbit_extrapolation_python_client.models.event_detection_type import EventDetectionType
from spacetower_orbit_extrapolation_python_client.models.event_generation_request import EventGenerationRequest
from spacetower_orbit_extrapolation_python_client.models.orbit import Orbit
from spacetower_orbit_extrapolation_python_client.models.time_span import TimeSpan
from typing import Optional, Set
from typing_extensions import Self

class ConjunctionEventRequest(EventGenerationRequest):
    """
    Computes Time of Closest Approach (TCA) with Keplerian propagation for secondary object. Assumption: the secondary state is given very close to the actual TCA, as in the case of a CDM. This legitimates Keplerian propagation with constant covariance. 
    """ # noqa: E501
    secondary_name: StrictStr = Field(description="Name of the secondary object", alias="secondaryName")
    secondary_orbit: Orbit = Field(alias="secondaryOrbit")
    __properties: ClassVar[List[str]] = ["timeSpan", "eventType", "eventDetectionType", "secondaryName", "secondaryOrbit"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConjunctionEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_span
        if self.time_span:
            _dict['timeSpan'] = self.time_span.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_orbit
        if self.secondary_orbit:
            _dict['secondaryOrbit'] = self.secondary_orbit.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConjunctionEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timeSpan": TimeSpan.from_dict(obj["timeSpan"]) if obj.get("timeSpan") is not None else None,
            "eventType": obj.get("eventType"),
            "eventDetectionType": obj.get("eventDetectionType"),
            "secondaryName": obj.get("secondaryName"),
            "secondaryOrbit": Orbit.from_dict(obj["secondaryOrbit"]) if obj.get("secondaryOrbit") is not None else None
        })
        return _obj


