# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.attitude_law import AttitudeLaw
from spacetower_orbit_extrapolation_python_client.models.attitude_law_type import AttitudeLawType
from spacetower_orbit_extrapolation_python_client.models.rotating_local_frame_id import RotatingLocalFrameId
from typing import Optional, Set
from typing_extensions import Self

class LocalFrameAttitudeLaw(AttitudeLaw):
    """
    Attitude law that defined by rotation angles around the axes of a local orbital frame. By default the satellite axes are aligned with those of the orbital frame
    """ # noqa: E501
    local_frame_id: RotatingLocalFrameId = Field(alias="localFrameId")
    alpha: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Offset with respect to the X axis of the local orbital frame")
    beta: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Offset with respect to the Y axis of the local orbital frame")
    gamma: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Offset with respect to the Z axis of the local orbital frame")
    __properties: ClassVar[List[str]] = ["attitudeLawType", "localFrameId", "alpha", "beta", "gamma"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LocalFrameAttitudeLaw from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LocalFrameAttitudeLaw from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attitudeLawType": obj.get("attitudeLawType"),
            "localFrameId": obj.get("localFrameId"),
            "alpha": obj.get("alpha") if obj.get("alpha") is not None else 0.0,
            "beta": obj.get("beta") if obj.get("beta") is not None else 0.0,
            "gamma": obj.get("gamma") if obj.get("gamma") is not None else 0.0
        })
        return _obj


