# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.cartesian_covariance_allowed_frame_id import CartesianCovarianceAllowedFrameId
from spacetower_orbit_extrapolation_python_client.models.field_description import FieldDescription
from typing import Optional, Set
from typing_extensions import Self

class CartesianCovarianceEphemeris(BaseModel):
    """
    Ephemeris of Cartesian covariance in an Earth-centered frame or a local orbital frame
    """ # noqa: E501
    dates: List[str]
    description: Optional[List[FieldDescription]] = None
    frame_id: Optional[CartesianCovarianceAllowedFrameId] = Field(default=None, alias="frameId")
    data: List[List[Union[StrictFloat, StrictInt]]] = Field(description="[[pos-x-var[m^2], pos-xy-cov[m^2], pos-xz-cov[m^2], pos-x-vel-x-cov[m^2/s], pos-x-vel-y-cov[m^2/s], pos-x-vel-z-cov[m^2/s], <br>                   pos-y-var[m^2],  pos-yz-cov[m^2], pos-y-vel-x-cov[m^2/s], pos-y-vel-y-cov[m^2/s], pos-y-vel-z-cov[m^2/s], <br>                                    pos-z-var[m^2],  pos-z-vel-x-cov[m^2/s], pos-z-vel-y-cov[m^2/s], pos-z-vel-z-cov[m^2/s], <br>                                                     vel-x-var[m^2/s^2],     vel-xy-cov[m^2/s^2],    vel-xz-cov[m^2/s^2], <br>                                                                             vel-y-var[m^2/s^2],     vel-yz-cov[m^2/s^2], <br>                                                                                                     vel-z-var[m^2/s^2]], ...] ")
    __properties: ClassVar[List[str]] = ["dates", "description", "frameId", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CartesianCovarianceEphemeris from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in description (list)
        _items = []
        if self.description:
            for _item in self.description:
                if _item:
                    _items.append(_item.to_dict())
            _dict['description'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CartesianCovarianceEphemeris from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dates": obj.get("dates"),
            "description": [FieldDescription.from_dict(_item) for _item in obj["description"]] if obj.get("description") is not None else None,
            "frameId": obj.get("frameId"),
            "data": obj.get("data")
        })
        return _obj


