# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.cartesian_covariance_allowed_frame_id import CartesianCovarianceAllowedFrameId
from spacetower_orbit_extrapolation_python_client.models.covariance_matrix import CovarianceMatrix
from spacetower_orbit_extrapolation_python_client.models.orbit_type import OrbitType
from typing import Optional, Set
from typing_extensions import Self

class CartesianCovarianceMatrix(CovarianceMatrix):
    """
    Covariance matrix for position and velocity
    """ # noqa: E501
    frame_id: Optional[CartesianCovarianceAllowedFrameId] = Field(default=None, alias="frameId")
    var_px: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Position x-component variance. Units [m^2]", alias="varPx")
    var_py: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Position y-component variance. Units [m^2]", alias="varPy")
    var_pz: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Position z-component variance. Units [m^2]", alias="varPz")
    var_vx: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Velocity x-component variance. Units [m^2/s^2]", alias="varVx")
    var_vy: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Velocity y-component variance. Units [m^2/s^2]", alias="varVy")
    var_vz: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Velocity z-component variance. Units [m^2/s^2]", alias="varVz")
    cov_vx_vy: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Velocity xy covariance. Units [m^2/s^2]", alias="covVxVy")
    cov_vx_vz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Velocity xz covariance. Units [m^2/s^2]", alias="covVxVz")
    cov_vy_vz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Velocity yz covariance. Units [m^2/s^2]", alias="covVyVz")
    cov_px_py: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Position xy covariance. Units [m^2]", alias="covPxPy")
    cov_px_pz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Position xz covariance. Units [m^2]", alias="covPxPz")
    cov_py_pz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Position yz covariance. Units [m^2]", alias="covPyPz")
    cov_px_vx: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPxVx")
    cov_px_vy: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPxVy")
    cov_px_vz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPxVz")
    cov_py_vx: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPyVx")
    cov_py_vy: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPyVy")
    cov_py_vz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPyVz")
    cov_pz_vx: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPzVx")
    cov_pz_vy: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPzVy")
    cov_pz_vz: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Units [m^2/s]", alias="covPzVz")
    __properties: ClassVar[List[str]] = ["covarianceType", "frameId", "varPx", "varPy", "varPz", "varVx", "varVy", "varVz", "covVxVy", "covVxVz", "covVyVz", "covPxPy", "covPxPz", "covPyPz", "covPxVx", "covPxVy", "covPxVz", "covPyVx", "covPyVy", "covPyVz", "covPzVx", "covPzVy", "covPzVz"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CartesianCovarianceMatrix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CartesianCovarianceMatrix from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "covarianceType": obj.get("covarianceType"),
            "frameId": obj.get("frameId"),
            "varPx": obj.get("varPx"),
            "varPy": obj.get("varPy"),
            "varPz": obj.get("varPz"),
            "varVx": obj.get("varVx"),
            "varVy": obj.get("varVy"),
            "varVz": obj.get("varVz"),
            "covVxVy": obj.get("covVxVy") if obj.get("covVxVy") is not None else 0.0,
            "covVxVz": obj.get("covVxVz") if obj.get("covVxVz") is not None else 0.0,
            "covVyVz": obj.get("covVyVz") if obj.get("covVyVz") is not None else 0.0,
            "covPxPy": obj.get("covPxPy") if obj.get("covPxPy") is not None else 0.0,
            "covPxPz": obj.get("covPxPz") if obj.get("covPxPz") is not None else 0.0,
            "covPyPz": obj.get("covPyPz") if obj.get("covPyPz") is not None else 0.0,
            "covPxVx": obj.get("covPxVx") if obj.get("covPxVx") is not None else 0.0,
            "covPxVy": obj.get("covPxVy") if obj.get("covPxVy") is not None else 0.0,
            "covPxVz": obj.get("covPxVz") if obj.get("covPxVz") is not None else 0.0,
            "covPyVx": obj.get("covPyVx") if obj.get("covPyVx") is not None else 0.0,
            "covPyVy": obj.get("covPyVy") if obj.get("covPyVy") is not None else 0.0,
            "covPyVz": obj.get("covPyVz") if obj.get("covPyVz") is not None else 0.0,
            "covPzVx": obj.get("covPzVx") if obj.get("covPzVx") is not None else 0.0,
            "covPzVy": obj.get("covPzVy") if obj.get("covPzVy") is not None else 0.0,
            "covPzVz": obj.get("covPzVz") if obj.get("covPzVz") is not None else 0.0
        })
        return _obj


