# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.ephemeris_type import EphemerisType
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from spacetower_orbit_extrapolation_python_client.models.attitude_ephemeris_request import AttitudeEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.battery_power_ephemeris_request import BatteryPowerEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris_request import GeodeticEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.mass_ephemeris_request import MassEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris_request import MeanOrbitEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.orbital_covariance_ephemeris_request import OrbitalCovarianceEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris_request import OsculatingOrbitEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.position_velocity_ephemeris_request import PositionVelocityEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.position_velocity_covariance_ephemeris_request import PositionVelocityCovarianceEphemerisRequest
    from spacetower_orbit_extrapolation_python_client.models.thrust_vector_ephemeris_request import ThrustVectorEphemerisRequest

class EphemerisGenerationRequest(BaseModel):
    """
    General options for exporting ephemeris. The end date must be posterior to the start one. A negative step means that the step-size is enforced from the end date rather than the start one
    """ # noqa: E501
    ephemeris_type: EphemerisType = Field(alias="ephemerisType")
    step: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The ephemeris step. Units [s]")
    start_date: Optional[str] = Field(default=None, description="The start date (UTC) of the ephemeris generation interval", alias="startDate")
    end_date: Optional[str] = Field(default=None, description="The end date (UTC) of the ephemeris generation interval", alias="endDate")
    __properties: ClassVar[List[str]] = ["ephemerisType", "step", "startDate", "endDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'ephemerisType'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'ATTITUDE': 'AttitudeEphemerisRequest','BATTERY_POWER': 'BatteryPowerEphemerisRequest','GEODETIC': 'GeodeticEphemerisRequest','MASS': 'MassEphemerisRequest','MEAN_ORBIT': 'MeanOrbitEphemerisRequest','ORBITAL_COVARIANCE': 'OrbitalCovarianceEphemerisRequest','OSCULATING_ORBIT': 'OsculatingOrbitEphemerisRequest','POSITION_VELOCITY': 'PositionVelocityEphemerisRequest','POSITION_VELOCITY_COVARIANCE': 'PositionVelocityCovarianceEphemerisRequest','THRUST_VECTOR': 'ThrustVectorEphemerisRequest'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[AttitudeEphemerisRequest, BatteryPowerEphemerisRequest, GeodeticEphemerisRequest, MassEphemerisRequest, MeanOrbitEphemerisRequest, OrbitalCovarianceEphemerisRequest, OsculatingOrbitEphemerisRequest, PositionVelocityEphemerisRequest, PositionVelocityCovarianceEphemerisRequest, ThrustVectorEphemerisRequest]]:
        """Create an instance of EphemerisGenerationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[AttitudeEphemerisRequest, BatteryPowerEphemerisRequest, GeodeticEphemerisRequest, MassEphemerisRequest, MeanOrbitEphemerisRequest, OrbitalCovarianceEphemerisRequest, OsculatingOrbitEphemerisRequest, PositionVelocityEphemerisRequest, PositionVelocityCovarianceEphemerisRequest, ThrustVectorEphemerisRequest]]:
        """Create an instance of EphemerisGenerationRequest from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'AttitudeEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.attitude_ephemeris_request").AttitudeEphemerisRequest.from_dict(obj)
        if object_type ==  'BatteryPowerEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.battery_power_ephemeris_request").BatteryPowerEphemerisRequest.from_dict(obj)
        if object_type ==  'GeodeticEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris_request").GeodeticEphemerisRequest.from_dict(obj)
        if object_type ==  'MassEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.mass_ephemeris_request").MassEphemerisRequest.from_dict(obj)
        if object_type ==  'MeanOrbitEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris_request").MeanOrbitEphemerisRequest.from_dict(obj)
        if object_type ==  'OrbitalCovarianceEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.orbital_covariance_ephemeris_request").OrbitalCovarianceEphemerisRequest.from_dict(obj)
        if object_type ==  'OsculatingOrbitEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris_request").OsculatingOrbitEphemerisRequest.from_dict(obj)
        if object_type ==  'PositionVelocityEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.position_velocity_ephemeris_request").PositionVelocityEphemerisRequest.from_dict(obj)
        if object_type ==  'PositionVelocityCovarianceEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.position_velocity_covariance_ephemeris_request").PositionVelocityCovarianceEphemerisRequest.from_dict(obj)
        if object_type ==  'ThrustVectorEphemerisRequest':
            return import_module("spacetower_orbit_extrapolation_python_client.models.thrust_vector_ephemeris_request").ThrustVectorEphemerisRequest.from_dict(obj)

        raise ValueError("EphemerisGenerationRequest failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


