# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.celestial_body_configuration import CelestialBodyConfiguration
from spacetower_orbit_extrapolation_python_client.models.perturbation import Perturbation
from typing import Optional, Set
from typing_extensions import Self

class PerturbationsConfiguration(BaseModel):
    """
    Perturbation force models configuration
    """ # noqa: E501
    celestial_body_configuration: Optional[CelestialBodyConfiguration] = Field(default=None, alias="celestialBodyConfiguration")
    perturbations: List[Perturbation]
    __properties: ClassVar[List[str]] = ["celestialBodyConfiguration", "perturbations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerturbationsConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of celestial_body_configuration
        if self.celestial_body_configuration:
            _dict['celestialBodyConfiguration'] = self.celestial_body_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in perturbations (list)
        _items = []
        if self.perturbations:
            for _item in self.perturbations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['perturbations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerturbationsConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "celestialBodyConfiguration": CelestialBodyConfiguration.from_dict(obj["celestialBodyConfiguration"]) if obj.get("celestialBodyConfiguration") is not None else None,
            "perturbations": [Perturbation.from_dict(_item) for _item in obj["perturbations"]] if obj.get("perturbations") is not None else None
        })
        return _obj


