# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.geodetic_ephemeris_request import GeodeticEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.mean_orbit_ephemeris_request import MeanOrbitEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.orbital_event_request import OrbitalEventRequest
from spacetower_orbit_extrapolation_python_client.models.osculating_orbit_ephemeris_request import OsculatingOrbitEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.position_velocity_ephemeris_request import PositionVelocityEphemerisRequest
from spacetower_orbit_extrapolation_python_client.models.reference_frames_configuration import ReferenceFramesConfiguration
from spacetower_orbit_extrapolation_python_client.models.station_event_request import StationEventRequest
from spacetower_orbit_extrapolation_python_client.models.tle import TLE
from typing import Optional, Set
from typing_extensions import Self

class TleExtrapolationRequest(BaseModel):
    """
    TleExtrapolationRequest
    """ # noqa: E501
    target_date: str = Field(description="timescale UTC", alias="targetDate")
    tle: TLE
    orbital_events_request: Optional[OrbitalEventRequest] = Field(default=None, alias="orbitalEventsRequest")
    station_event_request: Optional[StationEventRequest] = Field(default=None, alias="stationEventRequest")
    mean_orbit_ephemeris_request: Optional[MeanOrbitEphemerisRequest] = Field(default=None, alias="meanOrbitEphemerisRequest")
    osculating_orbit_ephemeris_request: Optional[OsculatingOrbitEphemerisRequest] = Field(default=None, alias="osculatingOrbitEphemerisRequest")
    position_velocity_ephemeris_request: Optional[PositionVelocityEphemerisRequest] = Field(default=None, alias="positionVelocityEphemerisRequest")
    geodetic_ephemeris_request: Optional[GeodeticEphemerisRequest] = Field(default=None, alias="geodeticEphemerisRequest")
    reference_frames_configuration: Optional[ReferenceFramesConfiguration] = Field(default=None, alias="referenceFramesConfiguration")
    __properties: ClassVar[List[str]] = ["targetDate", "tle", "orbitalEventsRequest", "stationEventRequest", "meanOrbitEphemerisRequest", "osculatingOrbitEphemerisRequest", "positionVelocityEphemerisRequest", "geodeticEphemerisRequest", "referenceFramesConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TleExtrapolationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tle
        if self.tle:
            _dict['tle'] = self.tle.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orbital_events_request
        if self.orbital_events_request:
            _dict['orbitalEventsRequest'] = self.orbital_events_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of station_event_request
        if self.station_event_request:
            _dict['stationEventRequest'] = self.station_event_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mean_orbit_ephemeris_request
        if self.mean_orbit_ephemeris_request:
            _dict['meanOrbitEphemerisRequest'] = self.mean_orbit_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of osculating_orbit_ephemeris_request
        if self.osculating_orbit_ephemeris_request:
            _dict['osculatingOrbitEphemerisRequest'] = self.osculating_orbit_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of position_velocity_ephemeris_request
        if self.position_velocity_ephemeris_request:
            _dict['positionVelocityEphemerisRequest'] = self.position_velocity_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geodetic_ephemeris_request
        if self.geodetic_ephemeris_request:
            _dict['geodeticEphemerisRequest'] = self.geodetic_ephemeris_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reference_frames_configuration
        if self.reference_frames_configuration:
            _dict['referenceFramesConfiguration'] = self.reference_frames_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TleExtrapolationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "targetDate": obj.get("targetDate"),
            "tle": TLE.from_dict(obj["tle"]) if obj.get("tle") is not None else None,
            "orbitalEventsRequest": OrbitalEventRequest.from_dict(obj["orbitalEventsRequest"]) if obj.get("orbitalEventsRequest") is not None else None,
            "stationEventRequest": StationEventRequest.from_dict(obj["stationEventRequest"]) if obj.get("stationEventRequest") is not None else None,
            "meanOrbitEphemerisRequest": MeanOrbitEphemerisRequest.from_dict(obj["meanOrbitEphemerisRequest"]) if obj.get("meanOrbitEphemerisRequest") is not None else None,
            "osculatingOrbitEphemerisRequest": OsculatingOrbitEphemerisRequest.from_dict(obj["osculatingOrbitEphemerisRequest"]) if obj.get("osculatingOrbitEphemerisRequest") is not None else None,
            "positionVelocityEphemerisRequest": PositionVelocityEphemerisRequest.from_dict(obj["positionVelocityEphemerisRequest"]) if obj.get("positionVelocityEphemerisRequest") is not None else None,
            "geodeticEphemerisRequest": GeodeticEphemerisRequest.from_dict(obj["geodeticEphemerisRequest"]) if obj.get("geodeticEphemerisRequest") is not None else None,
            "referenceFramesConfiguration": ReferenceFramesConfiguration.from_dict(obj["referenceFramesConfiguration"]) if obj.get("referenceFramesConfiguration") is not None else None
        })
        return _obj


