# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from spacetower_orbit_extrapolation_python_client.models.cartesian_covariance_frame_id import CartesianCovarianceFrameId
from typing import Optional, Set
from typing_extensions import Self

class CartesianCovarianceEphemerisRequest(BaseModel):
    """
    Options for exporting position/velocity covariance ephemeris in a given frame (inertial, earth-fixed or local frame)
    """ # noqa: E501
    step: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The ephemeris step. A negative step means that the step-size is enforced from the end date rather than the start one. Units [s]")
    start_date: Optional[str] = Field(default=None, description="The start date (UTC) of the ephemeris generation interval. If not provided, the initial date of the simulation is used", alias="startDate")
    end_date: Optional[str] = Field(default=None, description="The end date (UTC) of the ephemeris generation interval. If not provided, the final date of the simulation is used", alias="endDate")
    frame_id: CartesianCovarianceFrameId = Field(alias="frameId")
    __properties: ClassVar[List[str]] = ["step", "startDate", "endDate", "frameId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CartesianCovarianceEphemerisRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CartesianCovarianceEphemerisRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "step": obj.get("step"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "frameId": obj.get("frameId")
        })
        return _obj


