# coding: utf-8

"""
    Orbit Extrapolation API

    Orbit Extrapolation API

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from spacetower_orbit_extrapolation_python_client.models.closest_approach_event_log import ClosestApproachEventLog
from spacetower_orbit_extrapolation_python_client.models.field_of_view_event_log import FieldOfViewEventLog
from spacetower_orbit_extrapolation_python_client.models.orbital_event_log import OrbitalEventLog
from spacetower_orbit_extrapolation_python_client.models.station_visibility_event_log import StationVisibilityEventLog
from typing import Optional, Set
from typing_extensions import Self

class EventLogsWithAttitude(BaseModel):
    """
    EventLogsWithAttitude
    """ # noqa: E501
    orbital_event_logs: Optional[List[OrbitalEventLog]] = Field(default=None, description="The computed orbital elements events", alias="orbitalEventLogs")
    station_event_logs: Optional[List[StationVisibilityEventLog]] = Field(default=None, description="The computed station related events", alias="stationEventLogs")
    closest_approach_event_logs: Optional[List[ClosestApproachEventLog]] = Field(default=None, description="The computed conjunction events", alias="closestApproachEventLogs")
    field_of_view_event_logs: Optional[List[FieldOfViewEventLog]] = Field(default=None, description="The computed field of view events from on-board sensors", alias="fieldOfViewEventLogs")
    __properties: ClassVar[List[str]] = ["orbitalEventLogs", "stationEventLogs", "closestApproachEventLogs", "fieldOfViewEventLogs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventLogsWithAttitude from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in orbital_event_logs (list)
        _items = []
        if self.orbital_event_logs:
            for _item in self.orbital_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orbitalEventLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in station_event_logs (list)
        _items = []
        if self.station_event_logs:
            for _item in self.station_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stationEventLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in closest_approach_event_logs (list)
        _items = []
        if self.closest_approach_event_logs:
            for _item in self.closest_approach_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['closestApproachEventLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in field_of_view_event_logs (list)
        _items = []
        if self.field_of_view_event_logs:
            for _item in self.field_of_view_event_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fieldOfViewEventLogs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventLogsWithAttitude from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orbitalEventLogs": [OrbitalEventLog.from_dict(_item) for _item in obj["orbitalEventLogs"]] if obj.get("orbitalEventLogs") is not None else None,
            "stationEventLogs": [StationVisibilityEventLog.from_dict(_item) for _item in obj["stationEventLogs"]] if obj.get("stationEventLogs") is not None else None,
            "closestApproachEventLogs": [ClosestApproachEventLog.from_dict(_item) for _item in obj["closestApproachEventLogs"]] if obj.get("closestApproachEventLogs") is not None else None,
            "fieldOfViewEventLogs": [FieldOfViewEventLog.from_dict(_item) for _item in obj["fieldOfViewEventLogs"]] if obj.get("fieldOfViewEventLogs") is not None else None
        })
        return _obj


